/*     */ package org.jboss.security.plugins;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanConstructorInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.security.auth.login.Configuration;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class DefaultLoginConfig
/*     */   implements DynamicMBean
/*     */ {
/*  52 */   private static Logger log = Logger.getLogger(DefaultLoginConfig.class);
/*  53 */   private String authConfig = "auth.conf";
/*     */   private Configuration theConfig;
/*     */ 
/*     */   public String getAuthConfig()
/*     */   {
/*  65 */     return this.authConfig;
/*     */   }
/*     */ 
/*     */   public void setAuthConfig(String authConfURL)
/*     */     throws MalformedURLException
/*     */   {
/*  73 */     this.authConfig = authConfURL;
/*     */ 
/*  75 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*  76 */     URL loginConfig = loader.getResource(this.authConfig);
/*  77 */     if (loginConfig != null)
/*     */     {
/*  79 */       System.setProperty("java.security.auth.login.config", loginConfig.toExternalForm());
/*  80 */       log.info("Using JAAS LoginConfig: " + loginConfig.toExternalForm());
/*     */     }
/*     */     else
/*     */     {
/*  84 */       log.warn("Resource: " + this.authConfig + " not found");
/*     */     }
/*     */   }
/*     */ 
/*     */   public Configuration getConfiguration(Configuration currentConfig)
/*     */   {
/*  96 */     if (this.theConfig == null)
/*     */     {
/*  98 */       this.theConfig = Configuration.getConfiguration();
/*  99 */       log.debug("theConfig set to: " + this.theConfig);
/*     */     }
/* 101 */     return this.theConfig;
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String name)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 108 */     if (name.equals("AuthConfig"))
/* 109 */       return getAuthConfig();
/* 110 */     throw new AttributeNotFoundException(name + ": is not an attribute");
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(String[] names)
/*     */   {
/* 115 */     AttributeList list = new AttributeList();
/* 116 */     for (int n = 0; n < names.length; n++)
/*     */     {
/* 118 */       String name = names[n];
/*     */       try
/*     */       {
/* 121 */         Object value = getAttribute(name);
/* 122 */         Attribute attr = new Attribute(name, value);
/* 123 */         list.add(attr);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/* 129 */     return list;
/*     */   }
/*     */ 
/*     */   public MBeanInfo getMBeanInfo()
/*     */   {
/* 134 */     Class c = getClass();
/* 135 */     MBeanAttributeInfo[] attrInfo = { new MBeanAttributeInfo("AuthConfig", "java.lang.String", "", true, true, false) };
/*     */ 
/* 139 */     Constructor ctor = null;
/*     */     try
/*     */     {
/* 142 */       Class[] sig = new Class[0];
/* 143 */       ctor = c.getDeclaredConstructor(sig);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 148 */     MBeanConstructorInfo[] ctorInfo = { new MBeanConstructorInfo("Default ctor", ctor) };
/*     */ 
/* 151 */     Method getConfiguration = null;
/*     */     try
/*     */     {
/* 154 */       Class[] sig = { Configuration.class };
/* 155 */       getConfiguration = c.getDeclaredMethod("getConfiguration", sig);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 160 */     MBeanOperationInfo[] opInfo = { new MBeanOperationInfo("Access the LoginConfiguration", getConfiguration) };
/*     */ 
/* 163 */     MBeanInfo info = new MBeanInfo(c.getName(), "Default JAAS LoginConfig", attrInfo, ctorInfo, opInfo, null);
/*     */ 
/* 165 */     return info;
/*     */   }
/*     */ 
/*     */   public Object invoke(String method, Object[] args, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/* 171 */     Object value = null;
/* 172 */     if (method.equals("getConfiguration"))
/*     */     {
/* 174 */       Configuration currentConfig = (Configuration)args[0];
/* 175 */       value = getConfiguration(currentConfig);
/*     */     }
/* 177 */     return value;
/*     */   }
/*     */ 
/*     */   public void setAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/* 183 */     String name = attribute.getName();
/* 184 */     String value = (String)attribute.getValue();
/* 185 */     if (name.equals("AuthConfig"))
/*     */     {
/*     */       try
/*     */       {
/* 189 */         setAuthConfig(value);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 193 */         throw new MBeanException(e);
/*     */       }
/*     */     }
/*     */     else
/* 197 */       throw new AttributeNotFoundException(name + ": is not an attribute");
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(AttributeList attributeList)
/*     */   {
/* 202 */     AttributeList list = new AttributeList();
/* 203 */     for (int n = 0; n < attributeList.size(); n++)
/*     */     {
/* 205 */       Attribute attr = (Attribute)attributeList.get(n);
/*     */       try
/*     */       {
/* 208 */         setAttribute(attr);
/* 209 */         list.add(attr);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/* 215 */     return list;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.plugins.DefaultLoginConfig
 * JD-Core Version:    0.6.0
 */