/*    */ package org.jboss.security.mapping.providers.principal;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import java.security.cert.X509Certificate;
/*    */ import java.util.Map;
/*    */ import javax.security.auth.x500.X500Principal;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.security.auth.certs.SubjectCNMapping;
/*    */ import org.jboss.security.mapping.MappingProvider;
/*    */ import org.jboss.security.mapping.MappingResult;
/*    */ 
/*    */ public class SubjectCNMapper
/*    */   implements MappingProvider<Principal>
/*    */ {
/* 49 */   private static final Logger log = Logger.getLogger(SubjectCNMapper.class);
/* 50 */   private Map options = null;
/*    */   private MappingResult<Principal> result;
/*    */ 
/*    */   public void init(Map opt)
/*    */   {
/* 55 */     this.options = opt;
/*    */   }
/*    */ 
/*    */   public void setMappingResult(MappingResult res)
/*    */   {
/* 60 */     this.result = res;
/*    */   }
/*    */ 
/*    */   public void performMapping(Map contextMap, Principal principal)
/*    */   {
/* 65 */     if (!(principal instanceof X500Principal))
/* 66 */       return;
/* 67 */     if (contextMap == null) {
/* 68 */       throw new IllegalArgumentException("ContextMap is null");
/*    */     }
/* 70 */     X509Certificate[] certs = (X509Certificate[])(X509Certificate[])contextMap.get("X509");
/* 71 */     if (certs != null)
/*    */     {
/* 73 */       SubjectCNMapping sdn = new SubjectCNMapping();
/* 74 */       principal = sdn.toPrinicipal(certs);
/* 75 */       if (log.isTraceEnabled()) {
/* 76 */         log.trace("Mapped to Principal:" + principal);
/*    */       }
/*    */     }
/* 79 */     this.result.setMappedObject(principal);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.mapping.providers.principal.SubjectCNMapper
 * JD-Core Version:    0.6.0
 */