/*    */ package org.jboss.security.mapping.providers;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import java.security.acl.Group;
/*    */ import java.util.Map;
/*    */ import java.util.Properties;
/*    */ import java.util.Set;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.security.mapping.MappingProvider;
/*    */ import org.jboss.security.mapping.MappingResult;
/*    */ 
/*    */ public class PrincipalToRoleMappingProvider
/*    */   implements MappingProvider<Group>
/*    */ {
/* 44 */   private static final Logger log = Logger.getLogger(PrincipalToRoleMappingProvider.class);
/*    */   private static final String PRINCIPAL_ROLES_MAP = "principalRolesMap";
/* 49 */   private Map options = null;
/*    */   private MappingResult<Group> result;
/* 52 */   private Properties principalRoleMapProperties = null;
/*    */ 
/*    */   public void init(Map opt)
/*    */   {
/* 56 */     this.options = opt;
/* 57 */     if (log.isTraceEnabled())
/* 58 */       log.trace("Module Options=" + this.options);
/* 59 */     if (this.options != null)
/*    */     {
/* 61 */       if (this.options.containsKey("principalRolesMap"))
/*    */       {
/* 63 */         this.principalRoleMapProperties = ((Properties)this.options.get("principalRolesMap"));
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public void setMappingResult(MappingResult res)
/*    */   {
/* 70 */     this.result = res;
/*    */   }
/*    */ 
/*    */   public void performMapping(Map contextMap, Group mappedObject)
/*    */   {
/* 75 */     Set principals = (Set)contextMap.get("PrincipalsSet");
/* 76 */     for (Principal p : principals)
/*    */     {
/* 78 */       String pname = p.getName().trim();
/* 79 */       boolean containsP = this.principalRoleMapProperties.containsKey(pname);
/* 80 */       log.trace("Principal:" + pname + " is contained in options map:" + containsP);
/* 81 */       if (containsP) {
/* 82 */         String commaSeparatedRoles = this.principalRoleMapProperties.getProperty(pname);
/* 83 */         if (log.isTraceEnabled())
/* 84 */           log.trace("Principal:" + p.getName() + ":roles add=" + commaSeparatedRoles);
/* 85 */         String[] tokens = MappingProviderUtil.getRolesFromCommaSeparatedString(commaSeparatedRoles);
/* 86 */         int len = tokens != null ? tokens.length : 0;
/* 87 */         for (int i = 0; i < len; i++)
/*    */         {
/* 89 */           mappedObject.addMember(MappingProviderUtil.instantiatePrincipal(p.getClass(), tokens[i]));
/*    */         }
/*    */       }
/*    */     }
/* 92 */     this.result.setMappedObject(mappedObject);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.mapping.providers.PrincipalToRoleMappingProvider
 * JD-Core Version:    0.6.0
 */