/*     */ package org.jboss.security.mapping.providers;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.mapping.MappingProvider;
/*     */ import org.jboss.security.mapping.MappingResult;
/*     */ 
/*     */ public class PolicyContextIdRoleMappingProvider
/*     */   implements MappingProvider<Group>
/*     */ {
/*  51 */   private static Logger log = Logger.getLogger(PolicyContextIdRoleMappingProvider.class);
/*  52 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*  54 */   private Map options = null;
/*     */   private MappingResult<Group> result;
/*  57 */   private Properties policyContextIdToFileNameProps = new Properties();
/*     */   private static final String PROPERTIES_ID = "map";
/*     */   private static final String EXTERNAL_ID = "externalProperties";
/*     */ 
/*     */   public void init(Map opt)
/*     */   {
/*  64 */     this.options = opt;
/*  65 */     if (this.trace) {
/*  66 */       log.trace("Module Options=" + opt);
/*     */     }
/*  68 */     if (this.options != null)
/*     */     {
/*  71 */       this.policyContextIdToFileNameProps = ((Properties)this.options.get("map"));
/*  72 */       if (this.policyContextIdToFileNameProps == null)
/*     */       {
/*  75 */         String filename = (String)this.options.get("externalProperties");
/*  76 */         if (filename != null)
/*     */           try
/*     */           {
/*  79 */             this.policyContextIdToFileNameProps = loadProperties(filename);
/*     */           }
/*     */           catch (IOException e)
/*     */           {
/*  83 */             if (this.trace)
/*  84 */               log.trace("Loading external properties file=", e);
/*     */           }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMappingResult(MappingResult res)
/*     */   {
/*  92 */     this.result = res;
/*     */   }
/*     */ 
/*     */   public void performMapping(Map contextMap, Group mappedObject)
/*     */   {
/*  97 */     ArrayList tempPrincipalList = new ArrayList();
/*     */ 
/*  99 */     Principal principal = null;
/* 100 */     Set principals = (Set)contextMap.get("PrincipalsSet");
/* 101 */     for (Principal p : principals)
/*     */     {
/* 103 */       if (!(p instanceof Group))
/*     */       {
/* 105 */         principal = p;
/* 106 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 110 */     if (principal == null) {
/* 111 */       throw new IllegalStateException("Authenticated Principal not found");
/*     */     }
/*     */ 
/* 114 */     String contextId = PolicyContext.getContextID();
/* 115 */     if (this.trace)
/* 116 */       log.trace("Policy Context ID=" + contextId);
/* 117 */     if ((contextId != null) && (this.policyContextIdToFileNameProps != null) && (this.policyContextIdToFileNameProps.containsKey(contextId)))
/*     */     {
/* 121 */       String filename = this.policyContextIdToFileNameProps.getProperty(contextId);
/*     */       try
/*     */       {
/* 124 */         Properties props = loadProperties(filename);
/* 125 */         String rolesToAdd = props.getProperty(principal.getName());
/* 126 */         String[] addRoles = null;
/* 127 */         if (rolesToAdd != null) {
/* 128 */           addRoles = MappingProviderUtil.getRolesFromCommaSeparatedString(rolesToAdd);
/*     */         }
/*     */ 
/* 131 */         Enumeration groupMembers = mappedObject.members();
/* 132 */         while (groupMembers.hasMoreElements())
/*     */         {
/* 134 */           tempPrincipalList.add(groupMembers.nextElement());
/*     */         }
/*     */ 
/* 138 */         for (Principal p : tempPrincipalList)
/*     */         {
/* 140 */           mappedObject.removeMember(p);
/*     */         }
/*     */ 
/* 144 */         MappingProviderUtil.addRoles(mappedObject, addRoles);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 148 */         if (this.trace)
/* 149 */           log.trace("Exception:", e);
/*     */       }
/*     */     }
/* 152 */     this.result.setMappedObject(mappedObject);
/*     */   }
/*     */ 
/*     */   private Properties loadProperties(String filename) throws IOException
/*     */   {
/* 157 */     Properties props = new Properties();
/* 158 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/* 159 */     props.load(tcl.getResourceAsStream(filename));
/* 160 */     return props;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.mapping.providers.PolicyContextIdRoleMappingProvider
 * JD-Core Version:    0.6.0
 */