/*     */ package org.jboss.security.mapping.providers;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.mapping.MappingProvider;
/*     */ import org.jboss.security.mapping.MappingResult;
/*     */ 
/*     */ public class OptionsRoleMappingProvider
/*     */   implements MappingProvider<Group>
/*     */ {
/*  30 */   private static final Logger log = Logger.getLogger(OptionsRoleMappingProvider.class);
/*     */   private static final String REPLACE_ROLES_STRING = "replaceRoles";
/*     */   private static final String ROLES_MAP = "rolesMap";
/*     */   private MappingResult<Group> result;
/*  38 */   private Map options = null;
/*     */ 
/*  40 */   private Properties roleMapProperties = null;
/*     */ 
/*  45 */   private boolean REPLACE_ROLES = false;
/*     */ 
/*     */   public void init(Map opt)
/*     */   {
/*  49 */     this.options = opt;
/*  50 */     if (this.options != null)
/*     */     {
/*  52 */       if (this.options.containsKey("replaceRoles"))
/*     */       {
/*  54 */         this.REPLACE_ROLES = "true".equalsIgnoreCase((String)this.options.get("replaceRoles"));
/*     */       }
/*  56 */       if (this.options.containsKey("rolesMap"))
/*     */       {
/*  58 */         this.roleMapProperties = ((Properties)this.options.get("rolesMap"));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMappingResult(MappingResult res)
/*     */   {
/*  65 */     this.result = res;
/*     */   }
/*     */ 
/*     */   public void performMapping(Map contextMap, Group mappedObject)
/*     */   {
/*  70 */     ArrayList removeMembers = new ArrayList();
/*  71 */     ArrayList addMembers = new ArrayList();
/*     */ 
/*  74 */     Enumeration enumer = mappedObject.members();
/*  75 */     while (enumer.hasMoreElements())
/*     */     {
/*  77 */       Principal p = (Principal)enumer.nextElement();
/*  78 */       String name = p.getName();
/*  79 */       String commaSeparatedRoles = this.roleMapProperties.getProperty(name);
/*  80 */       if (commaSeparatedRoles != null)
/*     */       {
/*  82 */         String[] tokens = MappingProviderUtil.getRolesFromCommaSeparatedString(commaSeparatedRoles);
/*  83 */         int len = tokens != null ? tokens.length : 0;
/*  84 */         for (int i = 0; i < len; i++)
/*     */         {
/*  86 */           if (this.REPLACE_ROLES)
/*  87 */             removeMembers.add(p);
/*  88 */           addMembers.add(MappingProviderUtil.instantiatePrincipal(p.getClass(), tokens[i]));
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*  93 */     for (Principal p : removeMembers)
/*     */     {
/*  95 */       mappedObject.removeMember(p);
/*     */     }
/*     */ 
/*  98 */     for (Principal p : addMembers)
/*     */     {
/* 100 */       mappedObject.addMember(p);
/*     */     }
/*     */ 
/* 103 */     this.result.setMappedObject(mappedObject);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.mapping.providers.OptionsRoleMappingProvider
 * JD-Core Version:    0.6.0
 */