/*     */ package org.jboss.security.mapping.providers;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SimpleGroup;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.jboss.security.mapping.MappingProvider;
/*     */ import org.jboss.security.mapping.MappingResult;
/*     */ 
/*     */ public class DeploymentRolesMappingProvider
/*     */   implements MappingProvider<Group>
/*     */ {
/*  49 */   private static Logger log = Logger.getLogger(DeploymentRolesMappingProvider.class);
/*  50 */   private boolean trace = log.isTraceEnabled();
/*     */   private MappingResult<Group> result;
/*     */ 
/*     */   public void init(Map options)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setMappingResult(MappingResult res)
/*     */   {
/*  60 */     this.result = res;
/*     */   }
/*     */ 
/*     */   public void performMapping(Map map, Group mappedObject)
/*     */   {
/*  70 */     if ((map == null) || (map.isEmpty())) {
/*  71 */       throw new IllegalArgumentException("Context Map is null or empty");
/*     */     }
/*     */ 
/*  74 */     Principal principal = (Principal)map.get("Principal");
/*  75 */     Map principalRolesMap = (Map)map.get("deploymentPrincipalRolesMap");
/*  76 */     if (this.trace) {
/*  77 */       log.trace("Principal=" + principal + ":principalRolesMap=" + principalRolesMap);
/*     */     }
/*  79 */     if ((principal == null) || (principalRolesMap == null) || (principalRolesMap.isEmpty())) {
/*  80 */       return;
/*     */     }
/*  82 */     Set roleset = (Set)principalRolesMap.get(principal.getName());
/*  83 */     if (roleset != null)
/*     */     {
/*  85 */       Group newRoles = new SimpleGroup("Roles");
/*  86 */       Iterator iter = roleset.iterator();
/*  87 */       while (iter.hasNext())
/*     */       {
/*  89 */         String rolename = (String)iter.next();
/*  90 */         newRoles.addMember(createNewPrincipal(mappedObject, rolename));
/*     */       }
/*  92 */       mappedObject = MappingProviderUtil.replacePrincipals(mappedObject, newRoles);
/*     */     }
/*  94 */     this.result.setMappedObject(mappedObject);
/*     */   }
/*     */ 
/*     */   private Principal createNewPrincipal(Group mappedObject, String name)
/*     */   {
/* 105 */     Principal p = new SimplePrincipal(name);
/*     */ 
/* 108 */     if (mappedObject.members().hasMoreElements())
/*     */     {
/* 110 */       Principal origp = (Principal)mappedObject.members().nextElement();
/* 111 */       p = MappingProviderUtil.instantiatePrincipal(origp.getClass(), name);
/* 112 */       if (p == null)
/* 113 */         p = new SimplePrincipal(name);
/*     */     }
/* 115 */     return p;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.mapping.providers.DeploymentRolesMappingProvider
 * JD-Core Version:    0.6.0
 */