/*     */ package org.jboss.security.jndi;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ 
/*     */ class SecurityAssociationActions
/*     */ {
/*     */   static void setPrincipalInfo(Principal principal, Object credential)
/*     */   {
/* 108 */     SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential);
/* 109 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static void setPrincipalInfo(Principal principal, Object credential, Subject subject) {
/* 113 */     SetPrincipalInfoStackAction action = new SetPrincipalInfoStackAction(principal, credential, subject);
/* 114 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static void popPrincipalInfo() {
/* 118 */     PopPrincipalInfoAction action = new PopPrincipalInfoAction(null);
/* 119 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static void setServer()
/*     */   {
/* 124 */     AccessController.doPrivileged(SetServerAction.ACTION);
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader() {
/* 128 */     ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
/* 129 */     return loader;
/*     */   }
/*     */ 
/*     */   private static class SetServerAction
/*     */     implements PrivilegedAction
/*     */   {
/*  99 */     static PrivilegedAction ACTION = new SetServerAction();
/*     */ 
/*     */     public Object run() {
/* 102 */       SecurityAssociation.setServer();
/* 103 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetTCLAction
/*     */     implements PrivilegedAction
/*     */   {
/*  89 */     static PrivilegedAction ACTION = new GetTCLAction();
/*     */ 
/*     */     public Object run() {
/*  92 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*  93 */       return loader;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class PopPrincipalInfoAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     public Object run()
/*     */     {
/*  82 */       SecurityAssociation.popSubjectContext();
/*  83 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class SetPrincipalInfoAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Principal principal;
/*     */     Object credential;
/*     */ 
/*     */     SetPrincipalInfoAction(Principal principal, Object credential)
/*     */     {
/*  66 */       this.principal = principal;
/*  67 */       this.credential = credential;
/*     */     }
/*     */ 
/*     */     public Object run() {
/*  71 */       SecurityAssociation.setCredential(this.credential);
/*  72 */       this.credential = null;
/*  73 */       SecurityAssociation.setPrincipal(this.principal);
/*  74 */       this.principal = null;
/*  75 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class SetPrincipalInfoStackAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Principal principal;
/*     */     Object credential;
/*     */     Subject subject;
/*     */ 
/*     */     SetPrincipalInfoStackAction(Principal principal, Object credential, Subject subject)
/*     */     {
/*  46 */       this.principal = principal;
/*  47 */       this.credential = credential;
/*  48 */       this.subject = subject;
/*     */     }
/*     */ 
/*     */     public Object run() {
/*  52 */       SecurityAssociation.pushSubjectContext(this.subject, this.principal, this.credential);
/*  53 */       this.credential = null;
/*  54 */       this.principal = null;
/*  55 */       this.subject = null;
/*  56 */       return null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jndi.SecurityAssociationActions
 * JD-Core Version:    0.6.0
 */