/*     */ package org.jboss.security.jacc;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import javax.security.jacc.PolicyContextHandler;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SubjectInfo;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ public class SubjectPolicyContextHandler
/*     */   implements PolicyContextHandler
/*     */ {
/*  47 */   public static final HashSet EMPTY_SET = new HashSet();
/*     */ 
/*     */   public Object getContext(String key, Object data)
/*     */     throws PolicyContextException
/*     */   {
/*  99 */     if (!key.equalsIgnoreCase("javax.security.auth.Subject.container")) {
/* 100 */       return null;
/*     */     }
/* 102 */     Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
/* 103 */     return subject;
/*     */   }
/*     */ 
/*     */   public String[] getKeys()
/*     */     throws PolicyContextException
/*     */   {
/* 109 */     String[] keys = { "javax.security.auth.Subject.container" };
/* 110 */     return keys;
/*     */   }
/*     */ 
/*     */   public boolean supports(String key)
/*     */     throws PolicyContextException
/*     */   {
/* 116 */     return key.equalsIgnoreCase("javax.security.auth.Subject.container");
/*     */   }
/*     */ 
/*     */   private static class GetSubjectAction
/*     */     implements PrivilegedAction
/*     */   {
/*  51 */     static PrivilegedAction ACTION = new GetSubjectAction();
/*     */ 
/*     */     public Object run()
/*     */     {
/*  55 */       Subject theSubject = null;
/*  56 */       SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  57 */       if (sc != null)
/*     */       {
/*  59 */         SubjectInfo si = sc.getSubjectInfo();
/*     */ 
/*  61 */         if (si != null)
/*     */         {
/*  63 */           Subject activeSubject = si.getAuthenticatedSubject();
/*  64 */           RunAsIdentity callerRunAsIdentity = (RunAsIdentity)sc.getIncomingRunAs();
/*     */ 
/*  66 */           if (activeSubject != null)
/*     */           {
/*  68 */             Set principalsSet = null;
/*  69 */             if (callerRunAsIdentity == null)
/*     */             {
/*  71 */               principalsSet = activeSubject.getPrincipals();
/*     */             }
/*     */             else
/*     */             {
/*  75 */               principalsSet = callerRunAsIdentity.getPrincipalsSet();
/*     */             }
/*     */ 
/*  78 */             theSubject = new Subject(true, principalsSet, activeSubject.getPublicCredentials(), activeSubject.getPrivateCredentials());
/*     */           }
/*  84 */           else if (callerRunAsIdentity != null)
/*     */           {
/*  86 */             Set principalsSet = callerRunAsIdentity.getPrincipalsSet();
/*  87 */             theSubject = new Subject(true, principalsSet, SubjectPolicyContextHandler.EMPTY_SET, SubjectPolicyContextHandler.EMPTY_SET);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*  92 */       return theSubject;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jacc.SubjectPolicyContextHandler
 * JD-Core Version:    0.6.0
 */