/*     */ package org.jboss.security.jacc;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.security.AccessController;
/*     */ import java.security.Policy;
/*     */ import java.security.PrivilegedAction;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class SecurityService
/*     */ {
/*     */   private static final String JACC_POLICY_PROVIDER = "javax.security.jacc.policy.provider";
/*  49 */   private static final Logger log = Logger.getLogger(SecurityService.class);
/*     */   private Policy oldPolicy;
/*     */   private Policy jaccPolicy;
/*     */   private ObjectName policyName;
/*     */   private String policyAttributeName;
/*     */   private MBeanServer server;
/*     */ 
/*     */   public SecurityService()
/*     */   {
/*  59 */     this.policyAttributeName = "Policy";
/*     */   }
/*     */ 
/*     */   public ObjectName getPolicyName()
/*     */   {
/*  64 */     return this.policyName;
/*     */   }
/*     */ 
/*     */   public void setPolicyName(ObjectName policyName) {
/*  68 */     this.policyName = policyName;
/*     */   }
/*     */ 
/*     */   public String getPolicyAttributeName()
/*     */   {
/*  73 */     return this.policyAttributeName;
/*     */   }
/*     */ 
/*     */   public void setPolicyAttributeName(String policyAttributeName) {
/*  77 */     this.policyAttributeName = policyAttributeName;
/*     */   }
/*     */ 
/*     */   public MBeanServer getMBeanServer()
/*     */   {
/*  82 */     return this.server;
/*     */   }
/*     */ 
/*     */   public void setMBeanServer(MBeanServer server) {
/*  86 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public Policy getPolicy()
/*     */   {
/*  91 */     return this.jaccPolicy;
/*     */   }
/*     */ 
/*     */   public void setPolicy(Policy jaccPolicy) {
/*  95 */     this.jaccPolicy = jaccPolicy;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 108 */     this.oldPolicy = Policy.getPolicy();
/*     */ 
/* 111 */     if ((this.server != null) && (this.policyName != null) && (this.server.isRegistered(this.policyName)))
/*     */     {
/*     */       try
/*     */       {
/* 116 */         this.jaccPolicy = ((Policy)this.server.getAttribute(this.policyName, this.policyAttributeName));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 120 */         log.warn("Failed to get " + this.policyAttributeName + " attribute from: " + this.policyName, e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 126 */     if (this.jaccPolicy == null)
/*     */     {
/* 128 */       String provider = getProperty("javax.security.jacc.policy.provider", "org.jboss.security.jacc.DelegatingPolicy");
/*     */ 
/* 130 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 131 */       Class providerClass = loader.loadClass(provider);
/*     */       try
/*     */       {
/* 135 */         Class[] ctorSig = { Policy.class };
/* 136 */         Constructor ctor = providerClass.getConstructor(ctorSig);
/* 137 */         Object[] ctorArgs = { this.oldPolicy };
/* 138 */         this.jaccPolicy = ((Policy)ctor.newInstance(ctorArgs));
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 142 */         log.debug("Provider does not support ctor(Policy)");
/* 143 */         this.jaccPolicy = ((Policy)providerClass.newInstance());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 148 */     Policy.setPolicy(this.jaccPolicy);
/*     */ 
/* 151 */     this.jaccPolicy.refresh();
/*     */ 
/* 154 */     SubjectPolicyContextHandler handler = new SubjectPolicyContextHandler();
/* 155 */     PolicyContext.registerHandler("javax.security.auth.Subject.container", handler, true);
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 162 */     if (this.jaccPolicy != null)
/* 163 */       Policy.setPolicy(this.oldPolicy);
/*     */   }
/*     */ 
/*     */   static String getProperty(String name)
/*     */   {
/* 183 */     return getProperty(name, null);
/*     */   }
/*     */ 
/*     */   static String getProperty(String name, String defaultValue)
/*     */   {
/* 188 */     PrivilegedAction action = new PropertyAccessAction(name, defaultValue);
/* 189 */     String property = (String)AccessController.doPrivileged(action);
/* 190 */     return property;
/*     */   }
/*     */ 
/*     */   static class PropertyAccessAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     private String name;
/*     */     private String defaultValue;
/*     */ 
/*     */     PropertyAccessAction(String name, String defaultValue)
/*     */     {
/* 172 */       this.name = name;
/* 173 */       this.defaultValue = defaultValue;
/*     */     }
/*     */ 
/*     */     public Object run() {
/* 177 */       return System.getProperty(this.name, this.defaultValue);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jacc.SecurityService
 * JD-Core Version:    0.6.0
 */