/*    */ package org.jboss.security.jacc;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.net.URL;
/*    */ import java.net.URLClassLoader;
/*    */ import java.security.AccessController;
/*    */ import java.security.Policy;
/*    */ import java.security.PrivilegedAction;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ 
/*    */ class SecurityActions
/*    */ {
/*    */   static ClassLoader getContextClassloader()
/*    */   {
/* 46 */     return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction()
/*    */     {
/*    */       public Object run()
/*    */       {
/* 50 */         return Thread.currentThread().getContextClassLoader();
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   static URL findResource(URLClassLoader cl, String name) {
/* 57 */     return (URL)AccessController.doPrivileged(new PrivilegedAction(cl, name)
/*    */     {
/*    */       public Object run()
/*    */       {
/* 61 */         return this.val$cl.findResource(this.val$name);
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   static Policy getPolicy() {
/* 68 */     return (Policy)AccessController.doPrivileged(new PrivilegedAction()
/*    */     {
/*    */       public Object run()
/*    */       {
/* 72 */         return Policy.getPolicy();
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   static URL getResource(ClassLoader cl, String name) {
/* 79 */     return (URL)AccessController.doPrivileged(new PrivilegedAction(cl, name)
/*    */     {
/*    */       public Object run()
/*    */       {
/* 83 */         return this.val$cl.getResource(this.val$name);
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   static InputStream openStream(URL url) throws PrivilegedActionException {
/* 90 */     return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(url)
/*    */     {
/*    */       public Object run() throws IOException
/*    */       {
/* 94 */         return this.val$url.openStream();
/*    */       }
/*    */     });
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jacc.SecurityActions
 * JD-Core Version:    0.6.0
 */