/*    */ package org.jboss.security.jacc;
/*    */ 
/*    */ import java.net.URL;
/*    */ import java.security.Policy;
/*    */ import java.util.concurrent.ConcurrentHashMap;
/*    */ import javax.security.jacc.PolicyConfiguration;
/*    */ import javax.security.jacc.PolicyConfigurationFactory;
/*    */ import javax.security.jacc.PolicyContextException;
/*    */ import org.jboss.util.state.StateMachine;
/*    */ import org.jboss.util.state.xml.StateMachineParser;
/*    */ 
/*    */ public class JBossPolicyConfigurationFactory extends PolicyConfigurationFactory
/*    */ {
/*    */   private StateMachine configStateMachine;
/* 44 */   private ConcurrentHashMap policyConfigMap = new ConcurrentHashMap();
/*    */   private DelegatingPolicy policy;
/*    */ 
/*    */   public JBossPolicyConfigurationFactory()
/*    */   {
/*    */     try
/*    */     {
/* 56 */       ClassLoader loader = SecurityActions.getContextClassloader();
/* 57 */       URL states = SecurityActions.getResource(loader, "org/jboss/security/jacc/jacc-policy-config-states.xml");
/* 58 */       StateMachineParser smp = new StateMachineParser();
/* 59 */       this.configStateMachine = smp.parse(states);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 63 */       IllegalStateException ex = new IllegalStateException("Failed to parse jacc-policy-config-states.xml", e);
/* 64 */       ex.initCause(e);
/* 65 */       throw ex;
/*    */     }
/*    */ 
/* 68 */     Policy p = SecurityActions.getPolicy();
/* 69 */     if (!(p instanceof DelegatingPolicy))
/*    */     {
/* 72 */       p = DelegatingPolicy.getInstance();
/*    */     }
/* 74 */     this.policy = ((DelegatingPolicy)p);
/*    */   }
/*    */ 
/*    */   public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove)
/*    */     throws PolicyContextException
/*    */   {
/* 80 */     JBossPolicyConfiguration pc = (JBossPolicyConfiguration)this.policyConfigMap.get(contextID);
/* 81 */     if (pc == null)
/*    */     {
/* 83 */       StateMachine sm = (StateMachine)this.configStateMachine.clone();
/* 84 */       pc = new JBossPolicyConfiguration(contextID, this.policy, sm);
/* 85 */       this.policyConfigMap.put(contextID, pc);
/*    */     }
/* 87 */     pc.initPolicyConfiguration(remove);
/* 88 */     return pc;
/*    */   }
/*    */ 
/*    */   public boolean inService(String contextID)
/*    */     throws PolicyContextException
/*    */   {
/* 94 */     boolean inService = false;
/* 95 */     JBossPolicyConfiguration pc = (JBossPolicyConfiguration)this.policyConfigMap.get(contextID);
/* 96 */     if (pc != null)
/* 97 */       inService = pc.inService();
/* 98 */     return inService;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jacc.JBossPolicyConfigurationFactory
 * JD-Core Version:    0.6.0
 */