/*     */ package org.jboss.security.jacc;
/*     */ 
/*     */ import java.security.Permission;
/*     */ import java.security.PermissionCollection;
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.state.IllegalTransitionException;
/*     */ import org.jboss.util.state.State;
/*     */ import org.jboss.util.state.StateMachine;
/*     */ 
/*     */ public class JBossPolicyConfiguration
/*     */   implements PolicyConfiguration
/*     */ {
/*  44 */   private static Logger log = Logger.getLogger(JBossPolicyConfiguration.class);
/*     */   private String contextID;
/*     */   private DelegatingPolicy policy;
/*     */   private StateMachine configStateMachine;
/*     */   private boolean trace;
/*     */ 
/*     */   protected JBossPolicyConfiguration(String contextID, DelegatingPolicy policy, StateMachine configStateMachine)
/*     */     throws PolicyContextException
/*     */   {
/*  58 */     this.contextID = contextID;
/*  59 */     this.policy = policy;
/*  60 */     this.configStateMachine = configStateMachine;
/*     */ 
/*  62 */     if (contextID == null)
/*  63 */       throw new IllegalArgumentException("contextID cannot be null");
/*  64 */     if (policy == null)
/*  65 */       throw new IllegalArgumentException("policy cannot be null");
/*  66 */     if (configStateMachine == null) {
/*  67 */       throw new IllegalArgumentException("configStateMachine cannot be null");
/*     */     }
/*  69 */     validateState("getPolicyConfiguration");
/*  70 */     this.trace = log.isTraceEnabled();
/*  71 */     if (this.trace)
/*  72 */       log.trace("ctor, contextID=" + contextID);
/*     */   }
/*     */ 
/*     */   void initPolicyConfiguration(boolean remove)
/*     */     throws PolicyContextException
/*     */   {
/*  78 */     validateState("getPolicyConfiguration");
/*  79 */     this.policy.initPolicyConfiguration(this.contextID, remove);
/*     */   }
/*     */ 
/*     */   public void addToExcludedPolicy(Permission permission)
/*     */     throws PolicyContextException
/*     */   {
/*  85 */     if (this.trace)
/*  86 */       log.trace("addToExcludedPolicy, p=" + permission);
/*  87 */     validateState("addToExcludedPolicy");
/*  88 */     this.policy.addToExcludedPolicy(this.contextID, permission);
/*     */   }
/*     */ 
/*     */   public void addToExcludedPolicy(PermissionCollection permissions)
/*     */     throws PolicyContextException
/*     */   {
/*  94 */     if (this.trace)
/*  95 */       log.trace("addToExcludedPolicy, pc=" + permissions);
/*  96 */     validateState("addToExcludedPolicy");
/*  97 */     this.policy.addToExcludedPolicy(this.contextID, permissions);
/*     */   }
/*     */ 
/*     */   public void addToRole(String roleName, Permission permission)
/*     */     throws PolicyContextException
/*     */   {
/* 103 */     if (this.trace)
/* 104 */       log.trace("addToRole, roleName=" + roleName + ", p=" + permission);
/* 105 */     validateState("addToRole");
/* 106 */     this.policy.addToRole(this.contextID, roleName, permission);
/*     */   }
/*     */ 
/*     */   public void addToRole(String roleName, PermissionCollection permissions)
/*     */     throws PolicyContextException
/*     */   {
/* 112 */     if (this.trace)
/* 113 */       log.trace("addToRole, roleName=" + roleName + ", pc=" + permissions);
/* 114 */     validateState("addToRole");
/* 115 */     this.policy.addToRole(this.contextID, roleName, permissions);
/*     */   }
/*     */ 
/*     */   public void addToUncheckedPolicy(Permission permission)
/*     */     throws PolicyContextException
/*     */   {
/* 121 */     if (this.trace)
/* 122 */       log.trace("addToUncheckedPolicy, p=" + permission);
/* 123 */     validateState("addToUncheckedPolicy");
/* 124 */     this.policy.addToUncheckedPolicy(this.contextID, permission);
/*     */   }
/*     */ 
/*     */   public void addToUncheckedPolicy(PermissionCollection permissions)
/*     */     throws PolicyContextException
/*     */   {
/* 130 */     if (this.trace)
/* 131 */       log.trace("addToUncheckedPolicy, pc=" + permissions);
/* 132 */     validateState("addToUncheckedPolicy");
/* 133 */     this.policy.addToUncheckedPolicy(this.contextID, permissions);
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws PolicyContextException
/*     */   {
/* 139 */     if (this.trace)
/* 140 */       log.trace("commit");
/* 141 */     validateState("commit");
/* 142 */     this.policy.commit(this.contextID);
/*     */   }
/*     */ 
/*     */   public void delete()
/*     */     throws PolicyContextException
/*     */   {
/* 148 */     if (this.trace)
/* 149 */       log.trace("delete");
/* 150 */     validateState("delete");
/* 151 */     this.policy.delete(this.contextID);
/*     */   }
/*     */ 
/*     */   public String getContextID()
/*     */     throws PolicyContextException
/*     */   {
/* 157 */     validateState("getContextID");
/* 158 */     return this.contextID;
/*     */   }
/*     */ 
/*     */   public boolean inService()
/*     */     throws PolicyContextException
/*     */   {
/* 164 */     validateState("inService");
/* 165 */     State state = this.configStateMachine.getCurrentState();
/* 166 */     boolean inService = state.getName().equals("inService");
/* 167 */     return inService;
/*     */   }
/*     */ 
/*     */   public void linkConfiguration(PolicyConfiguration link)
/*     */     throws PolicyContextException
/*     */   {
/* 173 */     if (this.trace)
/* 174 */       log.trace("linkConfiguration, linkTo: " + link.getContextID());
/* 175 */     validateState("linkConfiguration");
/* 176 */     this.policy.linkConfiguration(this.contextID, link);
/*     */   }
/*     */ 
/*     */   public void removeExcludedPolicy()
/*     */     throws PolicyContextException
/*     */   {
/* 182 */     if (this.trace)
/* 183 */       log.trace("removeExcludedPolicy");
/* 184 */     validateState("removeExcludedPolicy");
/* 185 */     this.policy.removeExcludedPolicy(this.contextID);
/*     */   }
/*     */ 
/*     */   public void removeRole(String roleName)
/*     */     throws PolicyContextException
/*     */   {
/* 191 */     if (this.trace)
/* 192 */       log.trace("removeRole: " + roleName);
/* 193 */     validateState("removeRole");
/* 194 */     this.policy.removeRole(this.contextID, roleName);
/*     */   }
/*     */ 
/*     */   public void removeUncheckedPolicy()
/*     */     throws PolicyContextException
/*     */   {
/* 200 */     if (this.trace)
/* 201 */       log.trace("removeUncheckedPolicy");
/* 202 */     validateState("removeUncheckedPolicy");
/* 203 */     this.policy.removeUncheckedPolicy(this.contextID);
/*     */   }
/*     */ 
/*     */   protected void validateState(String action)
/*     */     throws PolicyContextException
/*     */   {
/*     */     try
/*     */     {
/* 211 */       this.configStateMachine.nextState(action);
/*     */     }
/*     */     catch (IllegalTransitionException e)
/*     */     {
/* 215 */       log.debug("validateState failure", e);
/* 216 */       throw new PolicyContextException("Operation not allowed", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jacc.JBossPolicyConfiguration
 * JD-Core Version:    0.6.0
 */