/*     */ package org.jboss.security.jacc;
/*     */ 
/*     */ import java.security.Permission;
/*     */ import java.security.PermissionCollection;
/*     */ import java.security.Permissions;
/*     */ import java.security.Principal;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.security.acl.Group;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ContextPolicy
/*     */ {
/*  48 */   private static Logger log = Logger.getLogger(ContextPolicy.class);
/*     */   private String contextID;
/*  50 */   private Permissions excludedPermissions = new Permissions();
/*  51 */   private Permissions uncheckedPermissions = new Permissions();
/*     */ 
/*  53 */   private HashMap rolePermissions = new HashMap();
/*     */   private boolean trace;
/*     */ 
/*     */   ContextPolicy(String contextID)
/*     */   {
/*  59 */     this.contextID = contextID;
/*  60 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   Permissions getPermissions()
/*     */   {
/*  65 */     Permissions perms = new Permissions();
/*  66 */     Enumeration eter = this.uncheckedPermissions.elements();
/*  67 */     while (eter.hasMoreElements())
/*     */     {
/*  69 */       Permission p = (Permission)eter.nextElement();
/*  70 */       perms.add(p);
/*     */     }
/*  72 */     Iterator iter = this.rolePermissions.values().iterator();
/*  73 */     while (iter.hasNext())
/*     */     {
/*  75 */       Permissions rp = (Permissions)iter.next();
/*  76 */       eter = rp.elements();
/*  77 */       while (eter.hasMoreElements())
/*     */       {
/*  79 */         Permission p = (Permission)eter.nextElement();
/*  80 */         perms.add(p);
/*     */       }
/*     */     }
/*  83 */     return perms;
/*     */   }
/*     */ 
/*     */   boolean implies(ProtectionDomain domain, Permission permission)
/*     */   {
/*  88 */     boolean implied = false;
/*     */ 
/*  90 */     if (this.excludedPermissions.implies(permission))
/*     */     {
/*  92 */       if (this.trace)
/*  93 */         log.trace("Denied: Matched excluded set, permission=" + permission);
/*  94 */       return false;
/*     */     }
/*     */ 
/*  98 */     if (this.uncheckedPermissions.implies(permission))
/*     */     {
/* 100 */       if (this.trace)
/* 101 */         log.trace("Allowed: Matched unchecked set, permission=" + permission);
/* 102 */       return true;
/*     */     }
/*     */ 
/* 106 */     Principal[] principals = domain.getPrincipals();
/* 107 */     int length = principals != null ? principals.length : 0;
/* 108 */     ArrayList princpalNames = new ArrayList();
/* 109 */     for (int n = 0; n < length; n++)
/*     */     {
/* 111 */       Principal p = principals[n];
/* 112 */       if ((p instanceof Group))
/*     */       {
/* 114 */         Group g = (Group)p;
/* 115 */         Enumeration iter = g.members();
/* 116 */         while (iter.hasMoreElements())
/*     */         {
/* 118 */           p = (Principal)iter.nextElement();
/* 119 */           String name = p.getName();
/* 120 */           princpalNames.add(name);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 125 */         String name = p.getName();
/* 126 */         princpalNames.add(name);
/*     */       }
/*     */     }
/* 129 */     if (princpalNames.size() > 0)
/*     */     {
/* 131 */       for (int n = 0; (!implied) && (n < princpalNames.size()); n++)
/*     */       {
/* 133 */         String name = (String)princpalNames.get(n);
/* 134 */         Permissions perms = (Permissions)this.rolePermissions.get(name);
/* 135 */         if (this.trace)
/* 136 */           log.trace("Checking role=" + name + " perms=" + perms);
/* 137 */         if (perms == null)
/*     */           continue;
/* 139 */         implied = perms.implies(permission);
/* 140 */         if (this.trace) {
/* 141 */           log.trace((implied ? "Allowed: " : "Denied: ") + " permission=" + permission);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/* 146 */     else if (this.trace) {
/* 147 */       log.trace("No principals found in domain: " + domain);
/*     */     }
/*     */ 
/* 150 */     return implied;
/*     */   }
/*     */ 
/*     */   void clear()
/*     */   {
/* 155 */     this.excludedPermissions = new Permissions();
/* 156 */     this.uncheckedPermissions = new Permissions();
/* 157 */     this.rolePermissions.clear();
/*     */   }
/*     */ 
/*     */   void addToExcludedPolicy(Permission permission)
/*     */     throws PolicyContextException
/*     */   {
/* 163 */     this.excludedPermissions.add(permission);
/*     */   }
/*     */ 
/*     */   void addToExcludedPolicy(PermissionCollection permissions)
/*     */     throws PolicyContextException
/*     */   {
/* 169 */     Enumeration iter = permissions.elements();
/* 170 */     while (iter.hasMoreElements())
/*     */     {
/* 172 */       Permission p = (Permission)iter.nextElement();
/* 173 */       this.excludedPermissions.add(p);
/*     */     }
/*     */   }
/*     */ 
/*     */   void addToRole(String roleName, Permission permission)
/*     */     throws PolicyContextException
/*     */   {
/* 180 */     Permissions perms = (Permissions)this.rolePermissions.get(roleName);
/* 181 */     if (perms == null)
/*     */     {
/* 183 */       perms = new Permissions();
/* 184 */       this.rolePermissions.put(roleName, perms);
/*     */     }
/* 186 */     perms.add(permission);
/*     */   }
/*     */ 
/*     */   void addToRole(String roleName, PermissionCollection permissions)
/*     */     throws PolicyContextException
/*     */   {
/* 192 */     Permissions perms = (Permissions)this.rolePermissions.get(roleName);
/* 193 */     if (perms == null)
/*     */     {
/* 195 */       perms = new Permissions();
/* 196 */       this.rolePermissions.put(roleName, perms);
/*     */     }
/* 198 */     Enumeration iter = permissions.elements();
/* 199 */     while (iter.hasMoreElements())
/*     */     {
/* 201 */       Permission p = (Permission)iter.nextElement();
/* 202 */       perms.add(p);
/*     */     }
/*     */   }
/*     */ 
/*     */   void addToUncheckedPolicy(Permission permission)
/*     */     throws PolicyContextException
/*     */   {
/* 209 */     this.uncheckedPermissions.add(permission);
/*     */   }
/*     */ 
/*     */   void addToUncheckedPolicy(PermissionCollection permissions)
/*     */     throws PolicyContextException
/*     */   {
/* 215 */     Enumeration iter = permissions.elements();
/* 216 */     while (iter.hasMoreElements())
/*     */     {
/* 218 */       Permission p = (Permission)iter.nextElement();
/* 219 */       this.uncheckedPermissions.add(p);
/*     */     }
/*     */   }
/*     */ 
/*     */   void commit()
/*     */     throws PolicyContextException
/*     */   {
/*     */   }
/*     */ 
/*     */   void delete()
/*     */     throws PolicyContextException
/*     */   {
/* 231 */     clear();
/*     */   }
/*     */ 
/*     */   String getContextID()
/*     */     throws PolicyContextException
/*     */   {
/* 237 */     return this.contextID;
/*     */   }
/*     */ 
/*     */   void linkConfiguration(ContextPolicy link)
/*     */     throws PolicyContextException
/*     */   {
/*     */   }
/*     */ 
/*     */   void removeExcludedPolicy()
/*     */     throws PolicyContextException
/*     */   {
/* 248 */     this.excludedPermissions = new Permissions();
/*     */   }
/*     */ 
/*     */   void removeRole(String roleName)
/*     */     throws PolicyContextException
/*     */   {
/* 254 */     this.rolePermissions.remove(roleName);
/*     */   }
/*     */ 
/*     */   void removeUncheckedPolicy()
/*     */     throws PolicyContextException
/*     */   {
/* 260 */     this.uncheckedPermissions = new Permissions();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 265 */     StringBuffer tmp = new StringBuffer("<ContextPolicy contextID='");
/* 266 */     tmp.append(this.contextID);
/* 267 */     tmp.append("'>\n");
/* 268 */     tmp.append("\t<ExcludedPermissions>\n");
/* 269 */     Enumeration iter = this.excludedPermissions.elements();
/* 270 */     while (iter.hasMoreElements())
/*     */     {
/* 272 */       Permission p = (Permission)iter.nextElement();
/* 273 */       tmp.append("<Permission type='");
/* 274 */       tmp.append(p.getClass());
/* 275 */       tmp.append("' name='");
/* 276 */       tmp.append(p.getName());
/* 277 */       tmp.append("' actions='");
/* 278 */       tmp.append(p.getActions());
/* 279 */       tmp.append("' />\n");
/*     */     }
/* 281 */     tmp.append("\t</ExcludedPermissions>\n");
/*     */ 
/* 283 */     tmp.append("\t<UncheckedPermissions>\n");
/* 284 */     iter = this.uncheckedPermissions.elements();
/* 285 */     while (iter.hasMoreElements())
/*     */     {
/* 287 */       Permission p = (Permission)iter.nextElement();
/* 288 */       tmp.append("<Permission type='");
/* 289 */       tmp.append(p.getClass());
/* 290 */       tmp.append(" name='");
/* 291 */       tmp.append(p.getName());
/* 292 */       tmp.append("' actions='");
/* 293 */       tmp.append(p.getActions());
/* 294 */       tmp.append("' />\n");
/*     */     }
/* 296 */     tmp.append("\t</UncheckedPermissions>\n");
/*     */ 
/* 298 */     tmp.append("\t<RolePermssions>\n");
/* 299 */     Iterator roles = this.rolePermissions.keySet().iterator();
/* 300 */     while (roles.hasNext())
/*     */     {
/* 302 */       String role = (String)roles.next();
/* 303 */       Permissions perms = (Permissions)this.rolePermissions.get(role);
/* 304 */       iter = perms.elements();
/* 305 */       tmp.append("\t\t<Role name='" + role + "'>\n");
/* 306 */       while (iter.hasMoreElements())
/*     */       {
/* 308 */         Permission p = (Permission)iter.nextElement();
/* 309 */         tmp.append("<Permission type='");
/* 310 */         tmp.append(p.getClass());
/* 311 */         tmp.append(" name='");
/* 312 */         tmp.append(p.getName());
/* 313 */         tmp.append("' actions='");
/* 314 */         tmp.append(p.getActions());
/* 315 */         tmp.append("' />\n");
/*     */       }
/* 317 */       tmp.append("\t\t</Role>\n");
/*     */     }
/* 319 */     tmp.append("\t</RolePermssions>");
/* 320 */     tmp.append("</ContextPolicy>\n");
/* 321 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jacc.ContextPolicy
 * JD-Core Version:    0.6.0
 */