/*     */ package org.jboss.security.integration.web;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.servlet.ServletRequest;
/*     */ import javax.servlet.ServletResponse;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.authorization.AuthorizationException;
/*     */ import org.jboss.security.authorization.resources.WebResource;
/*     */ import org.jboss.security.integration.ejb.SecurityHelper;
/*     */ 
/*     */ public class WebAuthorizationHelper extends SecurityHelper
/*     */ {
/*  53 */   private boolean enableAudit = true;
/*     */ 
/*     */   public WebAuthorizationHelper(SecurityContext sc, boolean enableAudit)
/*     */   {
/*  57 */     super(sc);
/*  58 */     this.enableAudit = enableAudit;
/*     */   }
/*     */ 
/*     */   public boolean checkResourcePermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, Subject callerSubject, AuthorizationManager authzMgr, String canonicalRequestURI)
/*     */   {
/*  65 */     boolean isAuthorized = false;
/*     */ 
/*  67 */     WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
/*  68 */     webResource.setServletRequest(request);
/*  69 */     webResource.setServletResponse(response);
/*  70 */     webResource.setCallerSubject(callerSubject);
/*  71 */     webResource.setCanonicalRequestURI(canonicalRequestURI);
/*     */     try
/*     */     {
/*  75 */       int permit = authzMgr.authorize(webResource);
/*  76 */       isAuthorized = permit == 1;
/*  77 */       String level = permit == 1 ? "Success" : "Failure";
/*  78 */       if (this.enableAudit)
/*  79 */         authorizationAudit(level, webResource, null);
/*     */     }
/*     */     catch (AuthorizationException e)
/*     */     {
/*  83 */       isAuthorized = false;
/*  84 */       if (log.isTraceEnabled())
/*  85 */         log.trace("hasResourcePermission check failed:" + e.getLocalizedMessage());
/*  86 */       if (this.enableAudit)
/*  87 */         authorizationAudit("Error", webResource, e);
/*     */     }
/*  89 */     return isAuthorized;
/*     */   }
/*     */ 
/*     */   public boolean hasRole(String roleName, Principal principal, String servletName, Set<Principal> principalRoles, AuthorizationManager authzMgr)
/*     */   {
/*  95 */     boolean hasTheRole = false;
/*  96 */     Map map = new HashMap();
/*  97 */     map.put("roleName", roleName);
/*  98 */     map.put("roleRefPermissionCheck", Boolean.TRUE);
/*  99 */     map.put("servletName", servletName);
/* 100 */     map.put("principal.roles", principalRoles);
/*     */ 
/* 102 */     map.put("authorizationManager", authzMgr);
/*     */ 
/* 104 */     WebResource webResource = new WebResource(Collections.unmodifiableMap(map));
/* 105 */     webResource.setPrincipal(principal);
/*     */     try
/*     */     {
/* 108 */       int permit = authzMgr.authorize(webResource);
/* 109 */       hasTheRole = permit == 1;
/* 110 */       String level = hasTheRole ? "Success" : "Failure";
/* 111 */       if (this.enableAudit)
/* 112 */         authorizationAudit(level, webResource, null);
/*     */     }
/*     */     catch (AuthorizationException e)
/*     */     {
/* 116 */       hasTheRole = false;
/* 117 */       if (log.isTraceEnabled())
/* 118 */         log.trace("hasRole check failed:" + e.getLocalizedMessage());
/* 119 */       if (this.enableAudit)
/* 120 */         authorizationAudit("Error", webResource, e);
/*     */     }
/* 122 */     return hasTheRole;
/*     */   }
/*     */ 
/*     */   public boolean hasUserDataPermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, AuthorizationManager authzMgr)
/*     */   {
/* 129 */     boolean hasPerm = false;
/* 130 */     contextMap.put("authorizationManager", authzMgr);
/*     */ 
/* 132 */     WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
/* 133 */     webResource.setServletRequest(request);
/* 134 */     webResource.setServletResponse(response);
/*     */     try
/*     */     {
/* 137 */       int permit = authzMgr.authorize(webResource);
/* 138 */       hasPerm = permit == 1;
/* 139 */       String level = hasPerm ? "Success" : "Failure";
/* 140 */       if (this.enableAudit)
/* 141 */         authorizationAudit(level, webResource, null);
/*     */     }
/*     */     catch (AuthorizationException e)
/*     */     {
/* 145 */       hasPerm = false;
/* 146 */       if (log.isTraceEnabled())
/* 147 */         log.trace("hasRole check failed:" + e.getLocalizedMessage());
/* 148 */       if (this.enableAudit)
/* 149 */         authorizationAudit("Error", webResource, e);
/*     */     }
/* 151 */     return hasPerm;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.integration.web.WebAuthorizationHelper
 * JD-Core Version:    0.6.0
 */