/*     */ package org.jboss.security.integration.ejb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.CodeSource;
/*     */ import java.security.Principal;
/*     */ import java.util.HashMap;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityRoleRef;
/*     */ import org.jboss.security.authorization.resources.EJBResource;
/*     */ 
/*     */ public class EJBAuthorizationHelper extends SecurityHelper
/*     */ {
/*     */   public EJBAuthorizationHelper(SecurityContext sc)
/*     */   {
/*  54 */     super(sc);
/*     */   }
/*     */ 
/*     */   public boolean authorize(String ejbName, Method ejbMethod, Principal ejbPrincipal, String invocationInterfaceString, CodeSource ejbCS, Subject callerSubject, RunAs callerRunAs, Set<Principal> methodRoles)
/*     */   {
/*  78 */     AuthorizationManager am = this.securityContext.getAuthorizationManager();
/*     */ 
/*  80 */     HashMap map = new HashMap();
/*  81 */     map.put("authorizationManager", am);
/*     */ 
/*  83 */     EJBResource ejbResource = new EJBResource(map);
/*  84 */     ejbResource.setCallerRunAsIdentity(callerRunAs);
/*  85 */     ejbResource.setEjbName(ejbName);
/*  86 */     ejbResource.setEjbMethod(ejbMethod);
/*  87 */     ejbResource.setPrincipal(ejbPrincipal);
/*  88 */     ejbResource.setEjbMethodInterface(invocationInterfaceString);
/*  89 */     ejbResource.setCodeSource(ejbCS);
/*  90 */     ejbResource.setCallerRunAsIdentity(callerRunAs);
/*  91 */     ejbResource.setCallerSubject(callerSubject);
/*  92 */     ejbResource.setMethodRoles(methodRoles);
/*     */ 
/*  94 */     boolean isAuthorized = false;
/*     */     try
/*     */     {
/*  97 */       int check = am.authorize(ejbResource);
/*  98 */       isAuthorized = check == 1;
/*  99 */       authorizationAudit(isAuthorized ? "Success" : "Failure", ejbResource, null);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 104 */       isAuthorized = false;
/* 105 */       if (log.isTraceEnabled())
/* 106 */         log.trace("Error in authorization:", e);
/* 107 */       authorizationAudit("Error", ejbResource, e);
/*     */     }
/*     */ 
/* 110 */     return isAuthorized;
/*     */   }
/*     */ 
/*     */   public Principal getCallerPrincipal(RealmMapping rm)
/*     */   {
/* 118 */     Principal caller = SecurityActions.getCallerPrincipal(this.securityContext);
/*     */ 
/* 123 */     if (rm != null)
/* 124 */       caller = rm.getPrincipal(caller);
/* 125 */     return caller;
/*     */   }
/*     */ 
/*     */   public boolean isCallerInRole(String roleName, String ejbName, Principal ejbPrincipal, Set<SecurityRoleRef> securityRoleRefs)
/*     */   {
/* 131 */     boolean isAuthorized = false;
/* 132 */     AuthorizationManager am = this.securityContext.getAuthorizationManager();
/*     */ 
/* 134 */     if (am == null) {
/* 135 */       throw new IllegalStateException("AuthorizationManager is null");
/*     */     }
/* 137 */     HashMap map = new HashMap();
/*     */ 
/* 139 */     map.put("authorizationManager", am);
/* 140 */     map.put("roleName", roleName);
/* 141 */     map.put("roleRefPermissionCheck", Boolean.TRUE);
/*     */ 
/* 144 */     EJBResource ejbResource = new EJBResource(map);
/*     */ 
/* 146 */     RunAs callerRunAs = this.securityContext.getIncomingRunAs();
/*     */ 
/* 148 */     ejbResource.setEjbName(ejbName);
/* 149 */     ejbResource.setPrincipal(ejbPrincipal);
/* 150 */     ejbResource.setCallerRunAsIdentity(callerRunAs);
/* 151 */     ejbResource.setSecurityRoleReferences(securityRoleRefs);
/*     */     try
/*     */     {
/* 155 */       int check = am.authorize(ejbResource);
/* 156 */       isAuthorized = check == 1;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 160 */       isAuthorized = false;
/* 161 */       if (log.isTraceEnabled())
/* 162 */         log.trace(roleName + "::isCallerInRole check failed:" + e.getLocalizedMessage());
/* 163 */       authorizationAudit("Error", ejbResource, e);
/*     */     }
/* 165 */     return isAuthorized;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.integration.ejb.EJBAuthorizationHelper
 * JD-Core Version:    0.6.0
 */