/*    */ package org.jboss.security.integration;
/*    */ 
/*    */ import javax.naming.Context;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.RefAddr;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.StringRefAddr;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class JNDIContextEstablishment
/*    */ {
/* 43 */   private Logger log = Logger.getLogger(JNDIContextEstablishment.class);
/*    */ 
/* 45 */   protected String BASE_CTX = "java:/jaas";
/*    */ 
/* 47 */   private String factoryName = SecurityDomainObjectFactory.class.getName();
/*    */ 
/*    */   public JNDIContextEstablishment()
/*    */   {
/*    */     try
/*    */     {
/* 53 */       initialize();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 57 */       this.log.trace("Error in initialization of JNDIContextEstablishment", e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void setBaseContext(String ctx) throws Exception
/*    */   {
/* 63 */     if (ctx == null)
/* 64 */       throw new IllegalArgumentException("ctx is null");
/* 65 */     this.BASE_CTX = ctx;
/* 66 */     initialize();
/*    */   }
/*    */ 
/*    */   public void setFactoryName(String factoryName)
/*    */   {
/* 71 */     this.factoryName = factoryName;
/*    */     try
/*    */     {
/* 74 */       initialize();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 78 */       this.log.trace("Error in initialization of JNDIContextEstablishment", e);
/*    */     }
/*    */   }
/*    */ 
/*    */   private void initialize() throws Exception
/*    */   {
/* 84 */     Context ctx = new InitialContext();
/*    */ 
/* 90 */     RefAddr refAddr = new StringRefAddr("nns", "JSM");
/* 91 */     Reference ref = new Reference("javax.naming.Context", refAddr, this.factoryName, null);
/* 92 */     ctx.rebind(this.BASE_CTX, ref);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.integration.JNDIContextEstablishment
 * JD-Core Version:    0.6.0
 */