/*     */ package org.jboss.security.identitytrust;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.security.config.ControlFlag;
/*     */ import org.jboss.security.config.IdentityTrustInfo;
/*     */ import org.jboss.security.config.SecurityConfiguration;
/*     */ import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
/*     */ 
/*     */ public class JBossIdentityTrustContext extends IdentityTrustContext
/*     */ {
/*  48 */   protected Logger log = Logger.getLogger(JBossIdentityTrustContext.class);
/*     */ 
/*     */   public JBossIdentityTrustContext(String secDomain, SecurityContext sc)
/*     */   {
/*  52 */     this.securityDomain = secDomain;
/*  53 */     this.securityContext = sc;
/*     */   }
/*     */ 
/*     */   public IdentityTrustManager.TrustDecision isTrusted()
/*     */     throws IdentityTrustException
/*     */   {
/*  59 */     IdentityTrustManager.TrustDecision decision = this.NOTAPPLICABLE;
/*     */     try
/*     */     {
/*  63 */       initializeModules();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  67 */       throw new IdentityTrustException(e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  72 */       decision = (IdentityTrustManager.TrustDecision)AccessController.doPrivileged(new PrivilegedExceptionAction()
/*     */       {
/*     */         public Object run() throws IdentityTrustException
/*     */         {
/*  76 */           IdentityTrustManager.TrustDecision result = JBossIdentityTrustContext.this.invokeTrusted();
/*  77 */           if (result == JBossIdentityTrustContext.this.PERMIT)
/*  78 */             JBossIdentityTrustContext.this.invokeCommit();
/*  79 */           if ((result == JBossIdentityTrustContext.this.DENY) || (result == JBossIdentityTrustContext.this.NOTAPPLICABLE))
/*     */           {
/*  81 */             JBossIdentityTrustContext.this.invokeAbort();
/*     */           }
/*  83 */           return result;
/*     */         }
/*     */       });
/*     */     }
/*     */     catch (PrivilegedActionException e) {
/*  89 */       Exception exc = e.getException();
/*  90 */       this.log.trace("Error in isAuthorize:", exc);
/*  91 */       invokeAbort();
/*  92 */       throw ((IdentityTrustException)exc);
/*     */     }
/*  94 */     return decision;
/*     */   }
/*     */ 
/*     */   private void initializeModules()
/*     */     throws Exception
/*     */   {
/* 100 */     this.modules.clear();
/*     */ 
/* 102 */     ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
/* 103 */     if (aPolicy == null) {
/* 104 */       throw new IllegalStateException("ApplicationPolicy not found for " + this.securityDomain);
/*     */     }
/* 106 */     IdentityTrustInfo iti = aPolicy.getIdentityTrustInfo();
/* 107 */     if (iti == null)
/* 108 */       return;
/* 109 */     IdentityTrustModuleEntry[] itmearr = iti.getIdentityTrustModuleEntry();
/* 110 */     for (IdentityTrustModuleEntry itme : itmearr)
/*     */     {
/* 112 */       ControlFlag cf = itme.getControlFlag();
/* 113 */       if (cf == null) {
/* 114 */         cf = ControlFlag.REQUIRED;
/*     */       }
/* 116 */       this.controlFlags.add(cf);
/* 117 */       this.modules.add(instantiateModule(itme.getName(), itme.getOptions()));
/*     */     }
/*     */   }
/*     */ 
/*     */   private IdentityTrustModule instantiateModule(String name, Map map) throws Exception
/*     */   {
/* 123 */     IdentityTrustModule im = null;
/* 124 */     ClassLoader tcl = SecurityActions.getContextClassLoader();
/*     */     try
/*     */     {
/* 127 */       Class clazz = tcl.loadClass(name);
/* 128 */       im = (IdentityTrustModule)clazz.newInstance();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 132 */       this.log.debug("Error instantiating IdentityTrustModule:", e);
/*     */     }
/* 134 */     if (im == null) {
/* 135 */       throw new IllegalStateException("IdentityTrustModule has not been instantiated");
/*     */     }
/* 137 */     im.initialize(this.securityContext, this.callbackHandler, this.sharedState, map);
/* 138 */     return im;
/*     */   }
/*     */ 
/*     */   private IdentityTrustManager.TrustDecision invokeTrusted()
/*     */     throws IdentityTrustException
/*     */   {
/* 145 */     boolean encounteredRequiredDeny = false;
/* 146 */     boolean encounteredRequiredNotApplicable = false;
/* 147 */     boolean encounteredOptionalError = false;
/* 148 */     IdentityTrustException moduleException = null;
/* 149 */     IdentityTrustManager.TrustDecision overallDecision = IdentityTrustManager.TrustDecision.NotApplicable;
/* 150 */     boolean encounteredRequiredPermit = false;
/*     */ 
/* 152 */     IdentityTrustManager.TrustDecision decision = this.NOTAPPLICABLE;
/* 153 */     int length = this.modules.size();
/*     */ 
/* 155 */     if (length == 0) {
/* 156 */       return decision;
/*     */     }
/* 158 */     for (int i = 0; i < length; i++)
/*     */     {
/* 160 */       IdentityTrustModule module = (IdentityTrustModule)this.modules.get(i);
/* 161 */       ControlFlag flag = (ControlFlag)this.controlFlags.get(i);
/*     */       try
/*     */       {
/* 164 */         decision = module.isTrusted();
/*     */       }
/*     */       catch (Exception ae)
/*     */       {
/* 168 */         decision = this.NOTAPPLICABLE;
/* 169 */         if (moduleException == null) {
/* 170 */           moduleException = new IdentityTrustException(ae);
/*     */         }
/*     */       }
/* 173 */       if (decision == this.PERMIT)
/*     */       {
/* 175 */         overallDecision = this.PERMIT;
/* 176 */         if (flag == ControlFlag.REQUIRED) {
/* 177 */           encounteredRequiredPermit = true;
/*     */         }
/* 179 */         if ((flag == ControlFlag.SUFFICIENT) && (!encounteredRequiredDeny)) {
/* 180 */           return this.PERMIT;
/*     */         }
/*     */ 
/*     */       }
/* 184 */       else if ((decision == this.NOTAPPLICABLE) && (flag == ControlFlag.REQUIRED))
/*     */       {
/* 186 */         encounteredRequiredNotApplicable = true;
/*     */       }
/*     */       else
/*     */       {
/* 191 */         if (flag == ControlFlag.REQUISITE)
/*     */         {
/* 193 */           this.log.trace("REQUISITE failed for " + module);
/* 194 */           if (moduleException == null)
/* 195 */             moduleException = new IdentityTrustException("Authorization failed");
/*     */           else {
/* 197 */             throw moduleException;
/*     */           }
/*     */         }
/* 200 */         if (flag == ControlFlag.REQUIRED)
/*     */         {
/* 202 */           this.log.trace("REQUIRED failed for " + module);
/* 203 */           encounteredRequiredDeny = true;
/*     */         }
/* 205 */         if (flag == ControlFlag.OPTIONAL) {
/* 206 */           encounteredOptionalError = true;
/*     */         }
/*     */       }
/*     */     }
/* 210 */     if (encounteredRequiredDeny)
/* 211 */       return this.DENY;
/* 212 */     if ((overallDecision == this.DENY) && (encounteredOptionalError))
/* 213 */       return this.DENY;
/* 214 */     if (overallDecision == this.DENY) {
/* 215 */       return this.DENY;
/*     */     }
/* 217 */     if ((encounteredRequiredNotApplicable) && (!encounteredRequiredPermit))
/* 218 */       return this.NOTAPPLICABLE;
/* 219 */     return this.PERMIT;
/*     */   }
/*     */ 
/*     */   private void invokeCommit()
/*     */     throws IdentityTrustException
/*     */   {
/* 225 */     int length = this.modules.size();
/* 226 */     for (int i = 0; i < length; i++)
/*     */     {
/* 228 */       IdentityTrustModule module = (IdentityTrustModule)this.modules.get(i);
/* 229 */       boolean bool = module.commit();
/* 230 */       if (!bool)
/* 231 */         throw new IdentityTrustException("commit on modules failed");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void invokeAbort()
/*     */     throws IdentityTrustException
/*     */   {
/* 238 */     int length = this.modules.size();
/* 239 */     for (int i = 0; i < length; i++)
/*     */     {
/* 241 */       IdentityTrustModule module = (IdentityTrustModule)this.modules.get(i);
/* 242 */       boolean bool = module.abort();
/* 243 */       if (!bool)
/* 244 */         throw new IdentityTrustException("abort on modules failed");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.identitytrust.JBossIdentityTrustContext
 * JD-Core Version:    0.6.0
 */