/*    */ package org.jboss.security.identity.plugins;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.security.Principal;
/*    */ import java.security.acl.Group;
/*    */ import org.jboss.security.identity.Identity;
/*    */ import org.jboss.security.identity.Role;
/*    */ 
/*    */ public class SimpleIdentity
/*    */   implements Identity, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 1L;
/*    */   private String name;
/*    */   private Role role;
/*    */ 
/*    */   public SimpleIdentity(String name)
/*    */   {
/* 47 */     this.name = name;
/*    */   }
/*    */ 
/*    */   public SimpleIdentity(String name, String roleName)
/*    */   {
/* 52 */     this.name = name;
/* 53 */     this.role = new SimpleRole(roleName);
/*    */   }
/*    */ 
/*    */   public SimpleIdentity(String name, Role role)
/*    */   {
/* 58 */     this.name = name;
/* 59 */     this.role = role;
/*    */   }
/*    */ 
/*    */   public Group asGroup()
/*    */   {
/*    */     try
/*    */     {
/* 66 */       Group gp = IdentityFactory.createGroup("Roles");
/* 67 */       gp.addMember(IdentityFactory.createPrincipal(this.role.getRoleName()));
/* 68 */       return gp;
/*    */     }
/*    */     catch (Exception e) {
/*    */     }
/* 72 */     throw new RuntimeException(e);
/*    */   }
/*    */ 
/*    */   public Principal asPrincipal()
/*    */   {
/*    */     try
/*    */     {
/* 80 */       return IdentityFactory.createPrincipal(this.name);
/*    */     }
/*    */     catch (Exception e) {
/*    */     }
/* 84 */     throw new RuntimeException(e);
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 90 */     return this.name;
/*    */   }
/*    */ 
/*    */   public Role getRole()
/*    */   {
/* 95 */     return this.role;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.identity.plugins.SimpleIdentity
 * JD-Core Version:    0.6.0
 */