/*     */ package org.jboss.security.config;
/*     */ 
/*     */ import java.security.Key;
/*     */ import java.security.spec.AlgorithmParameterSpec;
/*     */ import java.util.HashMap;
/*     */ 
/*     */ public class SecurityConfiguration
/*     */ {
/*  27 */   private static HashMap appPolicies = new HashMap();
/*     */   private static String cipherAlgorithm;
/*     */   private static int iterationCount;
/*     */   private static String salt;
/*     */   private static String keyStoreType;
/*     */   private static String keyStoreURL;
/*     */   private static String keyStorePass;
/*     */   private static String trustStoreType;
/*     */   private static String trustStorePass;
/*     */   private static String trustStoreURL;
/*     */   private static Key cipherKey;
/*     */   private static AlgorithmParameterSpec cipherSpec;
/*     */   private static boolean deepCopySubjectMode;
/*     */ 
/*     */   public static void addApplicationPolicy(ApplicationPolicy aP)
/*     */   {
/*  43 */     if (aP == null)
/*  44 */       throw new IllegalArgumentException("application policy is null");
/*  45 */     appPolicies.put(aP.getName(), aP);
/*     */   }
/*     */ 
/*     */   public static ApplicationPolicy getApplicationPolicy(String policyName)
/*     */   {
/*  50 */     return (ApplicationPolicy)appPolicies.get(policyName);
/*     */   }
/*     */ 
/*     */   public static String getCipherAlgorithm()
/*     */   {
/*  55 */     return cipherAlgorithm;
/*     */   }
/*     */ 
/*     */   public static void setCipherAlgorithm(String ca)
/*     */   {
/*  60 */     cipherAlgorithm = ca;
/*     */   }
/*     */ 
/*     */   public static Key getCipherKey()
/*     */   {
/*  65 */     return cipherKey;
/*     */   }
/*     */ 
/*     */   public static void setCipherKey(Key ca)
/*     */   {
/*  70 */     cipherKey = ca;
/*     */   }
/*     */ 
/*     */   public static AlgorithmParameterSpec getCipherSpec()
/*     */   {
/*  75 */     return cipherSpec;
/*     */   }
/*     */ 
/*     */   public static void setCipherSpec(AlgorithmParameterSpec aps)
/*     */   {
/*  80 */     cipherSpec = aps;
/*     */   }
/*     */ 
/*     */   public static int getIterationCount()
/*     */   {
/*  85 */     return iterationCount;
/*     */   }
/*     */ 
/*     */   public static void setIterationCount(int count)
/*     */   {
/*  93 */     iterationCount = count;
/*     */   }
/*     */ 
/*     */   public static String getSalt()
/*     */   {
/*  99 */     return salt;
/*     */   }
/*     */ 
/*     */   public static void setSalt(String s)
/*     */   {
/* 106 */     salt = s;
/*     */   }
/*     */ 
/*     */   public static String getKeyStoreType()
/*     */   {
/* 115 */     return keyStoreType;
/*     */   }
/*     */ 
/*     */   public static void setKeyStoreType(String type)
/*     */   {
/* 122 */     keyStoreType = type;
/*     */   }
/*     */ 
/*     */   public static String getKeyStoreURL()
/*     */   {
/* 128 */     return keyStoreURL;
/*     */   }
/*     */ 
/*     */   public static void setKeyStoreURL(String storeURL)
/*     */   {
/* 135 */     keyStoreURL = storeURL;
/*     */   }
/*     */ 
/*     */   public static String getKeyStorePass()
/*     */   {
/* 142 */     return keyStorePass;
/*     */   }
/*     */ 
/*     */   public static void setKeyStorePass(String password)
/*     */   {
/* 149 */     keyStorePass = password;
/*     */   }
/*     */ 
/*     */   public static String getTrustStoreType()
/*     */   {
/* 157 */     return trustStoreType;
/*     */   }
/*     */ 
/*     */   public static void setTrustStoreType(String type)
/*     */   {
/* 165 */     trustStoreType = type;
/*     */   }
/*     */ 
/*     */   public static String getTrustStorePass()
/*     */   {
/* 172 */     return trustStorePass;
/*     */   }
/*     */ 
/*     */   public static void setTrustStorePass(String password)
/*     */   {
/* 179 */     trustStorePass = password;
/*     */   }
/*     */ 
/*     */   public static String getTrustStoreURL()
/*     */   {
/* 186 */     return trustStoreURL;
/*     */   }
/*     */ 
/*     */   public static void setTrustStoreURL(String storeURL)
/*     */   {
/* 194 */     trustStoreURL = storeURL;
/*     */   }
/*     */ 
/*     */   public static boolean isDeepCopySubjectMode()
/*     */   {
/* 199 */     return deepCopySubjectMode;
/*     */   }
/*     */ 
/*     */   public static void setDeepCopySubjectMode(boolean dcsm)
/*     */   {
/* 204 */     deepCopySubjectMode = dcsm;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.config.SecurityConfiguration
 * JD-Core Version:    0.6.0
 */