/*     */ package org.jboss.security.config;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.audit.config.AuditProviderEntry;
/*     */ import org.jboss.security.auth.container.config.AuthModuleEntry;
/*     */ import org.jboss.security.auth.login.AppConfigurationEntryHolder;
/*     */ import org.jboss.security.auth.login.AuthenticationInfo;
/*     */ import org.jboss.security.auth.login.BaseAuthenticationInfo;
/*     */ import org.jboss.security.auth.login.JASPIAuthenticationInfo;
/*     */ import org.jboss.security.auth.login.LoginModuleStackHolder;
/*     */ import org.jboss.security.authorization.config.AuthorizationConfigEntryHolder;
/*     */ import org.jboss.security.authorization.config.AuthorizationModuleEntry;
/*     */ import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
/*     */ import org.jboss.xb.binding.GenericValueContainer;
/*     */ 
/*     */ public class ApplicationPolicyContainer
/*     */   implements GenericValueContainer
/*     */ {
/*  58 */   private static Logger log = Logger.getLogger(ApplicationPolicyContainer.class);
/*     */ 
/*  60 */   ApplicationPolicy info = null;
/*     */ 
/*  62 */   String authName = null;
/*     */ 
/*  64 */   String baseAppPolicyName = null;
/*     */ 
/*  66 */   List authenticationModuleEntries = new ArrayList();
/*  67 */   List authorizationModuleEntries = new ArrayList();
/*  68 */   List auditProviderEntries = new ArrayList();
/*  69 */   List identityTrustModuleEntries = new ArrayList();
/*     */ 
/*  71 */   Map loginModuleStackMap = new HashMap();
/*     */ 
/*  73 */   boolean isJASPIAuthentication = false;
/*  74 */   boolean isJAASAuthentication = false;
/*  75 */   boolean isAuthorization = false;
/*  76 */   boolean containsAudit = false;
/*  77 */   boolean containsIdentityTrust = false;
/*  78 */   boolean containsRoleMapping = false;
/*     */ 
/*  81 */   RoleMappingInfo roleMappingInfo = null;
/*  82 */   AuditInfo auditInfo = null;
/*  83 */   IdentityTrustInfo identityTrustInfo = null;
/*     */ 
/*     */   public void addChild(QName name, Object value)
/*     */   {
/*  90 */     log.debug("addChild::" + name + ":" + value);
/*  91 */     if ("name".equals(name.getLocalPart()))
/*     */     {
/*  93 */       this.authName = ((String)value);
/*     */     }
/*  95 */     else if ("extends".equals(name.getLocalPart()))
/*     */     {
/*  97 */       this.baseAppPolicyName = ((String)value);
/*     */     }
/*  99 */     else if ((value instanceof AppConfigurationEntryHolder))
/*     */     {
/* 101 */       AppConfigurationEntryHolder ace = (AppConfigurationEntryHolder)value;
/* 102 */       this.authenticationModuleEntries.add(ace.getEntry());
/* 103 */       this.isJAASAuthentication = true;
/*     */     }
/* 105 */     else if ((value instanceof AppConfigurationEntry))
/*     */     {
/* 107 */       AppConfigurationEntry ace = (AppConfigurationEntry)value;
/* 108 */       this.authenticationModuleEntries.add(ace);
/* 109 */       this.isJAASAuthentication = true;
/*     */     }
/* 111 */     else if ((value instanceof AuthModuleEntry))
/*     */     {
/* 113 */       AuthModuleEntry ame = (AuthModuleEntry)value;
/*     */ 
/* 115 */       String lmshName = ame.getLoginModuleStackHolderName();
/* 116 */       if (lmshName != null)
/* 117 */         ame.setLoginModuleStackHolder((LoginModuleStackHolder)this.loginModuleStackMap.get(lmshName));
/* 118 */       this.authenticationModuleEntries.add(ame);
/* 119 */       this.isJASPIAuthentication = true;
/*     */     }
/* 121 */     else if ((value instanceof LoginModuleStackHolder))
/*     */     {
/* 123 */       LoginModuleStackHolder lmsh = (LoginModuleStackHolder)value;
/* 124 */       this.loginModuleStackMap.put(lmsh.getName(), lmsh);
/* 125 */       this.isJASPIAuthentication = true;
/*     */     }
/* 127 */     else if ((value instanceof AuthorizationModuleEntry))
/*     */     {
/* 129 */       AuthorizationModuleEntry ame = (AuthorizationModuleEntry)value;
/* 130 */       if (!this.authorizationModuleEntries.contains(ame))
/* 131 */         this.authorizationModuleEntries.add(ame);
/* 132 */       this.isAuthorization = true;
/*     */     }
/* 134 */     else if ((value instanceof AuthorizationConfigEntryHolder))
/*     */     {
/* 136 */       AuthorizationConfigEntryHolder ame = (AuthorizationConfigEntryHolder)value;
/* 137 */       AuthorizationModuleEntry ameEntry = ame.getEntry();
/* 138 */       if (!this.authorizationModuleEntries.contains(ameEntry))
/* 139 */         this.authorizationModuleEntries.add(ameEntry);
/* 140 */       this.isAuthorization = true;
/*     */     }
/* 142 */     else if ((value instanceof AuditProviderEntry))
/*     */     {
/* 144 */       AuditProviderEntry ameEntry = (AuditProviderEntry)value;
/* 145 */       if (!this.auditProviderEntries.contains(ameEntry))
/* 146 */         this.auditProviderEntries.add(ameEntry);
/* 147 */       this.containsAudit = true;
/*     */     }
/* 149 */     else if ((value instanceof IdentityTrustModuleEntry))
/*     */     {
/* 151 */       IdentityTrustModuleEntry ameEntry = (IdentityTrustModuleEntry)value;
/* 152 */       if (!this.identityTrustModuleEntries.contains(ameEntry))
/* 153 */         this.identityTrustModuleEntries.add(ameEntry);
/* 154 */       this.containsIdentityTrust = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addMappingInfo(Object obj)
/*     */   {
/* 165 */     log.debug(obj);
/* 166 */     if ((obj instanceof RoleMappingInfo))
/*     */     {
/* 168 */       this.roleMappingInfo = ((RoleMappingInfo)obj);
/* 169 */       this.roleMappingInfo.setName(this.authName);
/* 170 */       this.containsRoleMapping = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object instantiate()
/*     */   {
/* 179 */     this.info = new ApplicationPolicy(this.authName);
/* 180 */     if (this.baseAppPolicyName != null) {
/* 181 */       this.info.setBaseApplicationPolicyName(this.baseAppPolicyName);
/*     */     }
/* 183 */     BaseAuthenticationInfo binfo = null;
/* 184 */     AuthorizationInfo ainfo = null;
/*     */ 
/* 186 */     if (this.isJAASAuthentication)
/*     */     {
/* 188 */       binfo = new AuthenticationInfo(this.authName);
/* 189 */       SecurityActions.addModules(binfo, this.authenticationModuleEntries);
/* 190 */       this.info.setAuthenticationInfo(binfo);
/*     */     }
/* 192 */     if (this.isJASPIAuthentication)
/*     */     {
/* 194 */       binfo = new JASPIAuthenticationInfo(this.authName);
/* 195 */       SecurityActions.addModules(binfo, this.authenticationModuleEntries);
/* 196 */       this.info.setAuthenticationInfo(binfo);
/*     */     }
/* 198 */     if (this.isAuthorization)
/*     */     {
/* 200 */       ainfo = new AuthorizationInfo(this.authName);
/* 201 */       SecurityActions.addModules(ainfo, this.authorizationModuleEntries);
/* 202 */       this.info.setAuthorizationInfo(ainfo);
/*     */     }
/* 204 */     if (this.containsRoleMapping)
/*     */     {
/* 206 */       this.info.setRoleMappingInfo(this.roleMappingInfo);
/*     */     }
/* 208 */     if (this.containsAudit)
/*     */     {
/* 210 */       this.auditInfo = new AuditInfo(this.authName);
/* 211 */       SecurityActions.addModules(this.auditInfo, this.auditProviderEntries);
/* 212 */       this.info.setAuditInfo(this.auditInfo);
/*     */     }
/* 214 */     if (this.containsIdentityTrust)
/*     */     {
/* 216 */       this.identityTrustInfo = new IdentityTrustInfo(this.authName);
/* 217 */       SecurityActions.addModules(this.identityTrustInfo, this.identityTrustModuleEntries);
/* 218 */       this.info.setIdentityTrustInfo(this.identityTrustInfo);
/*     */     }
/* 220 */     return this.info;
/*     */   }
/*     */ 
/*     */   public Class getTargetClass()
/*     */   {
/* 228 */     return ApplicationPolicy.class;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.config.ApplicationPolicyContainer
 * JD-Core Version:    0.6.0
 */