/*    */ package org.jboss.security.client;
/*    */ 
/*    */ import java.lang.reflect.Constructor;
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ 
/*    */ public class SecurityClientFactory
/*    */ {
/* 39 */   private static String defaultClient = "org.jboss.security.client.JBossSecurityClient";
/*    */ 
/*    */   public static SecurityClient getSecurityClient()
/*    */     throws Exception
/*    */   {
/* 50 */     return getSC(defaultClient);
/*    */   }
/*    */ 
/*    */   public static SecurityClient getSecurityClient(String client)
/*    */     throws Exception
/*    */   {
/* 61 */     return getSC(client);
/*    */   }
/*    */ 
/*    */   public static SecurityClient getSecurityClient(Class<?> clazz)
/*    */     throws Exception
/*    */   {
/* 73 */     if (!SecurityClient.class.isAssignableFrom(clazz)) {
/* 74 */       throw new IllegalArgumentException("clazz is not of SecurityClient type");
/*    */     }
/* 76 */     Constructor ctr = clazz.getConstructor(new Class[0]);
/* 77 */     return (SecurityClient)ctr.newInstance(new Object[0]);
/*    */   }
/*    */ 
/*    */   private static SecurityClient getSC(String client)
/*    */     throws PrivilegedActionException
/*    */   {
/* 83 */     return (SecurityClient)AccessController.doPrivileged(new PrivilegedExceptionAction(client)
/*    */     {
/*    */       public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException
/*    */       {
/* 87 */         Class clazz = Thread.currentThread().getContextClassLoader().loadClass(this.val$client);
/* 88 */         return clazz.newInstance();
/*    */       }
/*    */     });
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.client.SecurityClientFactory
 * JD-Core Version:    0.6.0
 */