/*     */ package org.jboss.security.client;
/*     */ 
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ 
/*     */ public abstract class SecurityClient
/*     */ {
/*  47 */   protected Object userPrincipal = null;
/*  48 */   protected Object credential = null;
/*  49 */   protected CallbackHandler callbackHandler = null;
/*  50 */   protected String loginConfigName = null;
/*  51 */   protected String saslMechanism = null;
/*  52 */   protected String saslAuthorizationId = null;
/*     */ 
/*  54 */   protected boolean jaasDesired = false;
/*  55 */   protected boolean saslDesired = false;
/*     */ 
/*     */   public void login()
/*     */     throws LoginException
/*     */   {
/*  63 */     if (this.jaasDesired) {
/*  64 */       performJAASLogin();
/*     */     }
/*  66 */     else if (this.saslDesired)
/*  67 */       peformSASLLogin();
/*     */     else
/*  69 */       performSimpleLogin();
/*     */   }
/*     */ 
/*     */   public void logout()
/*     */   {
/*  77 */     setSimple(null, null);
/*  78 */     setJAAS(null, null);
/*  79 */     setSASL(null, null, null);
/*  80 */     clearUpDesires();
/*  81 */     cleanUp();
/*     */   }
/*     */ 
/*     */   public void setSimple(Object username, Object credential)
/*     */   {
/*  91 */     this.userPrincipal = username;
/*  92 */     this.credential = credential;
/*     */   }
/*     */ 
/*     */   public void setJAAS(String configName, CallbackHandler cbh)
/*     */   {
/* 102 */     this.loginConfigName = configName;
/* 103 */     this.callbackHandler = cbh;
/* 104 */     clearUpDesires();
/* 105 */     this.jaasDesired = true;
/*     */   }
/*     */ 
/*     */   public void setSASL(String mechanism, String authorizationId, CallbackHandler cbh)
/*     */   {
/* 117 */     this.saslMechanism = mechanism;
/* 118 */     this.saslAuthorizationId = authorizationId;
/* 119 */     this.callbackHandler = cbh;
/* 120 */     clearUpDesires();
/* 121 */     this.saslDesired = true;
/*     */   }
/*     */   protected abstract void performJAASLogin() throws LoginException;
/*     */ 
/*     */   protected abstract void peformSASLLogin();
/*     */ 
/*     */   protected abstract void performSimpleLogin();
/*     */ 
/*     */   protected abstract void cleanUp();
/*     */ 
/* 135 */   private void clearUpDesires() { this.jaasDesired = false;
/* 136 */     this.saslDesired = false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.client.SecurityClient
 * JD-Core Version:    0.6.0
 */