/*    */ package org.jboss.security.client;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import javax.security.auth.login.LoginContext;
/*    */ import javax.security.auth.login.LoginException;
/*    */ import org.jboss.security.SecurityContext;
/*    */ import org.jboss.security.SecurityContextFactory;
/*    */ import org.jboss.security.SecurityContextUtil;
/*    */ import org.jboss.security.SimplePrincipal;
/*    */ import org.jboss.security.plugins.SecurityContextAssociation;
/*    */ 
/*    */ public class JBossSecurityClient extends SecurityClient
/*    */ {
/* 52 */   protected LoginContext lc = null;
/*    */ 
/*    */   protected void peformSASLLogin()
/*    */   {
/* 57 */     throw new RuntimeException("Not Implemented");
/*    */   }
/*    */ 
/*    */   protected void performJAASLogin()
/*    */     throws LoginException
/*    */   {
/* 63 */     this.lc = new LoginContext(this.loginConfigName, this.callbackHandler);
/* 64 */     this.lc.login();
/*    */   }
/*    */ 
/*    */   protected void performSimpleLogin()
/*    */   {
/* 70 */     Principal up = null;
/* 71 */     if ((this.userPrincipal instanceof String))
/* 72 */       up = new SimplePrincipal((String)this.userPrincipal);
/*    */     else {
/* 74 */       up = (Principal)this.userPrincipal;
/*    */     }
/* 76 */     SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 77 */     if (sc == null)
/*    */     {
/*    */       try
/*    */       {
/* 81 */         sc = SecurityContextFactory.createSecurityContext("CLIENT");
/*    */       }
/*    */       catch (Exception e)
/*    */       {
/* 85 */         throw new RuntimeException(e);
/*    */       }
/* 87 */       sc.getUtil().createSubjectInfo(up, this.credential, null);
/*    */     }
/* 89 */     SecurityContextAssociation.setSecurityContext(sc);
/*    */   }
/*    */ 
/*    */   protected void cleanUp()
/*    */   {
/* 95 */     SecurityContextAssociation.clearSecurityContext();
/* 96 */     if (this.lc != null)
/*    */       try
/*    */       {
/* 99 */         this.lc.logout();
/*    */       }
/*    */       catch (LoginException e)
/*    */       {
/* 103 */         throw new RuntimeException(e);
/*    */       }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.client.JBossSecurityClient
 * JD-Core Version:    0.6.0
 */