/*     */ package org.jboss.security.cache;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.Arrays;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.security.auth.Subject;
/*     */ 
/*     */ public class JBossAuthenticationCache
/*     */   implements SecurityCache<Principal>
/*     */ {
/*  44 */   private int initialCapacity = 16;
/*     */ 
/*  47 */   private float loadFactor = 0.75F;
/*     */ 
/*  50 */   private int concurrencyLevel = 16;
/*     */ 
/*  52 */   private ConcurrentHashMap<Principal, AuthCacheObject> cacheMap = null;
/*     */ 
/*     */   public JBossAuthenticationCache()
/*     */   {
/*  56 */     constructCache();
/*     */   }
/*     */ 
/*     */   public JBossAuthenticationCache(int initCapacity, float loadFactor, int level)
/*     */   {
/*  61 */     this.concurrencyLevel = level;
/*  62 */     this.loadFactor = loadFactor;
/*  63 */     this.initialCapacity = initCapacity;
/*  64 */     constructCache();
/*     */   }
/*     */ 
/*     */   public void addCacheEntry(Principal principal, Map<String, Object> map)
/*     */     throws SecurityCacheException
/*     */   {
/*     */     try
/*     */     {
/*  75 */       AuthCacheObject ao = new AuthCacheObject(map.get("Credential"), (Subject)map.get("Subject"));
/*     */ 
/*  77 */       this.cacheMap.put(principal, ao);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  81 */       throw new SecurityCacheException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean cacheHit(Principal principal)
/*     */   {
/*  90 */     return this.cacheMap.containsKey(principal);
/*     */   }
/*     */ 
/*     */   public void cacheOperation(Principal principal, Map<String, Object> map)
/*     */     throws SecurityCacheException
/*     */   {
/*  99 */     boolean isValid = false;
/* 100 */     if (!cacheHit(principal))
/* 101 */       throw new SecurityCacheException("Cache Miss");
/* 102 */     Object cred = map.get("Credential");
/* 103 */     AuthCacheObject ao = (AuthCacheObject)this.cacheMap.get(principal);
/* 104 */     Object cacheCred = ao.credential;
/*     */ 
/* 107 */     if ((cred == null) || (cacheCred == null))
/*     */     {
/* 109 */       if ((cred == null) && (cacheCred == null)) {
/* 110 */         isValid = true;
/*     */       }
/*     */     }
/* 113 */     else if (cacheCred.getClass().isAssignableFrom(cred.getClass()))
/*     */     {
/* 118 */       if ((cacheCred instanceof Comparable))
/*     */       {
/* 120 */         Comparable c = (Comparable)cacheCred;
/* 121 */         isValid = c.compareTo(cred) == 0;
/*     */       }
/* 123 */       else if ((cacheCred instanceof char[]))
/*     */       {
/* 125 */         char[] a1 = (char[])(char[])cacheCred;
/* 126 */         char[] a2 = (char[])(char[])cred;
/* 127 */         isValid = Arrays.equals(a1, a2);
/*     */       }
/* 129 */       else if ((cacheCred instanceof byte[]))
/*     */       {
/* 131 */         byte[] a1 = (byte[])(byte[])cacheCred;
/* 132 */         byte[] a2 = (byte[])(byte[])cred;
/* 133 */         isValid = Arrays.equals(a1, a2);
/*     */       }
/* 135 */       else if (cacheCred.getClass().isArray())
/*     */       {
/* 137 */         Object[] a1 = (Object[])(Object[])cacheCred;
/* 138 */         Object[] a2 = (Object[])(Object[])cred;
/* 139 */         isValid = Arrays.equals(a1, a2);
/*     */       }
/*     */       else
/*     */       {
/* 143 */         isValid = cacheCred.equals(cred);
/*     */       }
/*     */     }
/* 146 */     else if (((cacheCred instanceof char[])) && ((cred instanceof String)))
/*     */     {
/* 148 */       char[] a1 = (char[])(char[])cacheCred;
/* 149 */       char[] a2 = ((String)cred).toCharArray();
/* 150 */       isValid = Arrays.equals(a1, a2);
/*     */     }
/* 152 */     else if (((cacheCred instanceof String)) && ((cred instanceof char[])))
/*     */     {
/* 154 */       char[] a1 = ((String)cacheCred).toCharArray();
/* 155 */       char[] a2 = (char[])(char[])cred;
/* 156 */       isValid = Arrays.equals(a1, a2);
/*     */     }
/*     */ 
/* 159 */     if (!isValid)
/* 160 */       throw new SecurityCacheException("Cache Validation Failed");
/*     */   }
/*     */ 
/*     */   public <Y> Y get(Principal key)
/*     */     throws SecurityCacheException
/*     */   {
/* 168 */     Subject subj = null;
/* 169 */     if (cacheHit(key))
/*     */     {
/* 171 */       AuthCacheObject aco = (AuthCacheObject)this.cacheMap.get(key);
/* 172 */       subj = aco.subject;
/*     */     }
/* 174 */     return subj;
/*     */   }
/*     */ 
/*     */   private void constructCache()
/*     */   {
/* 179 */     this.cacheMap = new ConcurrentHashMap(this.initialCapacity, this.loadFactor, this.concurrencyLevel);
/*     */   }
/*     */ 
/*     */   private class AuthCacheObject
/*     */   {
/*     */     private Object credential;
/*     */     private Subject subject;
/*     */ 
/*     */     public AuthCacheObject(Object credential, Subject subject)
/*     */     {
/* 192 */       this.credential = credential;
/* 193 */       this.subject = subject;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.cache.JBossAuthenticationCache
 * JD-Core Version:    0.6.0
 */