/*     */ package org.jboss.security.authorization.sunxacml;
/*     */ 
/*     */ import com.sun.xacml.AbstractPolicy;
/*     */ import com.sun.xacml.EvaluationCtx;
/*     */ import com.sun.xacml.ParsingException;
/*     */ import com.sun.xacml.UnknownIdentifierException;
/*     */ import com.sun.xacml.combine.CombiningAlgFactory;
/*     */ import com.sun.xacml.combine.PolicyCombiningAlgorithm;
/*     */ import com.sun.xacml.ctx.Status;
/*     */ import com.sun.xacml.finder.PolicyFinder;
/*     */ import com.sun.xacml.finder.PolicyFinderModule;
/*     */ import com.sun.xacml.finder.PolicyFinderResult;
/*     */ import com.sun.xacml.support.finder.PolicyCollection;
/*     */ import com.sun.xacml.support.finder.PolicyReader;
/*     */ import com.sun.xacml.support.finder.TopLevelPolicyException;
/*     */ import java.io.File;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ 
/*     */ public class JBossStaticPolicyFinderModule extends PolicyFinderModule
/*     */ {
/*     */   private List policyList;
/*     */   private PolicyCollection policies;
/*  68 */   private File schemaFile = null;
/*     */ 
/*  70 */   private static URI policyId = JBossXACMLUtil.getDefaultPolicyID();
/*     */ 
/*  72 */   private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(JBossStaticPolicyFinderModule.class);
/*     */ 
/*  75 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*  78 */   private boolean encounteredParsingException = false;
/*     */ 
/*     */   public JBossStaticPolicyFinderModule(List policyList)
/*     */   {
/*  95 */     this.policyList = policyList;
/*  96 */     this.policies = new PolicyCollection();
/*     */ 
/*  98 */     String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
/*     */ 
/* 100 */     if (schemaName != null)
/* 101 */       this.schemaFile = new File(schemaName);
/*     */   }
/*     */ 
/*     */   public JBossStaticPolicyFinderModule(List policyList, String schemaFile)
/*     */   {
/* 117 */     this.policyList = policyList;
/* 118 */     this.policies = new PolicyCollection();
/*     */ 
/* 120 */     if (schemaFile != null)
/* 121 */       this.schemaFile = new File(schemaFile);
/*     */   }
/*     */ 
/*     */   public JBossStaticPolicyFinderModule(String combiningAlg, List policyList)
/*     */     throws URISyntaxException, UnknownIdentifierException
/*     */   {
/* 147 */     PolicyCombiningAlgorithm alg = (PolicyCombiningAlgorithm)(PolicyCombiningAlgorithm)CombiningAlgFactory.getInstance().createAlgorithm(new URI(combiningAlg));
/*     */ 
/* 151 */     this.policyList = policyList;
/* 152 */     this.policies = new PolicyCollection(alg, policyId);
/*     */ 
/* 154 */     String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
/*     */ 
/* 156 */     if (schemaName != null)
/* 157 */       this.schemaFile = new File(schemaName);
/*     */   }
/*     */ 
/*     */   public JBossStaticPolicyFinderModule(String combiningAlg, List policyList, String schemaFile)
/*     */     throws URISyntaxException, UnknownIdentifierException
/*     */   {
/* 183 */     PolicyCombiningAlgorithm alg = (PolicyCombiningAlgorithm)(PolicyCombiningAlgorithm)CombiningAlgFactory.getInstance().createAlgorithm(new URI(combiningAlg));
/*     */ 
/* 187 */     this.policyList = policyList;
/* 188 */     this.policies = new PolicyCollection(alg, policyId);
/*     */ 
/* 190 */     if (schemaFile != null)
/* 191 */       this.schemaFile = new File(schemaFile);
/*     */   }
/*     */ 
/*     */   public boolean isRequestSupported()
/*     */   {
/* 202 */     return true;
/*     */   }
/*     */ 
/*     */   public void init(PolicyFinder finder)
/*     */   {
/* 214 */     String clazzName = getClass().getName();
/*     */ 
/* 216 */     PolicyReader reader = new PolicyReader(finder, java.util.logging.Logger.getLogger(clazzName), this.schemaFile);
/*     */ 
/* 219 */     Iterator it = this.policyList.iterator();
/* 220 */     while (it.hasNext())
/*     */     {
/* 222 */       String str = (String)(String)it.next();
/* 223 */       AbstractPolicy policy = null;
/*     */       try
/*     */       {
/*     */         try
/*     */         {
/* 229 */           URL url = new URL(str);
/* 230 */           policy = reader.readPolicy(url);
/*     */         }
/*     */         catch (MalformedURLException murle)
/*     */         {
/* 235 */           policy = reader.readPolicy(new File(str));
/*     */         }
/*     */       }
/*     */       catch (ParsingException e)
/*     */       {
/* 240 */         this.encounteredParsingException = true;
/* 241 */         log.error("Parsing Exception in policy:", e);
/* 242 */       }continue;
/*     */ 
/* 246 */       if (!this.policies.addPolicy(policy))
/* 247 */         log.warn("tried to load the same policy multiple times: " + str);
/*     */     }
/*     */   }
/*     */ 
/*     */   public PolicyFinderResult findPolicy(EvaluationCtx context)
/*     */   {
/* 264 */     List aList = new ArrayList();
/* 265 */     aList.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
/*     */     try
/*     */     {
/* 269 */       if (this.encounteredParsingException)
/* 270 */         return new PolicyFinderResult(new Status(aList));
/* 271 */       AbstractPolicy policy = this.policies.getPolicy(context);
/*     */ 
/* 273 */       if (policy == null) {
/* 274 */         return new PolicyFinderResult();
/*     */       }
/* 276 */       return new PolicyFinderResult(policy);
/*     */     }
/*     */     catch (TopLevelPolicyException tlpe) {
/*     */     }
/* 280 */     return new PolicyFinderResult(tlpe.getStatus());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.sunxacml.JBossStaticPolicyFinderModule
 * JD-Core Version:    0.6.0
 */