/*     */ package org.jboss.security.authorization.resources;
/*     */ 
/*     */ import java.util.Enumeration;
/*     */ import java.util.Map;
/*     */ import javax.servlet.ServletRequest;
/*     */ import javax.servlet.ServletResponse;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import org.jboss.security.authorization.ResourceType;
/*     */ 
/*     */ public class WebResource extends JavaEEResource
/*     */ {
/*  44 */   private ServletRequest servletRequest = null;
/*  45 */   private ServletResponse servletResponse = null;
/*     */ 
/*  47 */   private String canonicalRequestURI = null;
/*     */ 
/*     */   public WebResource()
/*     */   {
/*     */   }
/*     */ 
/*     */   public WebResource(Map<String, Object> map)
/*     */   {
/*  63 */     this.map = map;
/*     */   }
/*     */ 
/*     */   public ResourceType getLayer()
/*     */   {
/*  71 */     return ResourceType.WEB;
/*     */   }
/*     */ 
/*     */   public String getCanonicalRequestURI()
/*     */   {
/*  76 */     return this.canonicalRequestURI;
/*     */   }
/*     */ 
/*     */   public void setCanonicalRequestURI(String canonicalRequestURI)
/*     */   {
/*  81 */     this.canonicalRequestURI = canonicalRequestURI;
/*     */   }
/*     */ 
/*     */   public ServletRequest getServletRequest()
/*     */   {
/*  86 */     return this.servletRequest;
/*     */   }
/*     */ 
/*     */   public void setServletRequest(ServletRequest servletRequest)
/*     */   {
/*  91 */     this.servletRequest = servletRequest;
/*     */   }
/*     */ 
/*     */   public ServletResponse getServletResponse()
/*     */   {
/*  96 */     return this.servletResponse;
/*     */   }
/*     */ 
/*     */   public void setServletResponse(ServletResponse servletResponse)
/*     */   {
/* 101 */     this.servletResponse = servletResponse;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 106 */     StringBuffer buf = new StringBuffer();
/* 107 */     buf.append("[").append(getClass().getName()).append(":contextMap=").append(this.map).append("canonicalRequestURI=").append(this.canonicalRequestURI).append("request=").append(deriveUsefulInfo()).append("CodeSource=").append(this.codeSource).append("]");
/*     */ 
/* 112 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   private String deriveUsefulInfo()
/*     */   {
/* 117 */     if (!(this.servletRequest instanceof HttpServletRequest)) {
/* 118 */       return " ";
/*     */     }
/* 120 */     HttpServletRequest httpRequest = (HttpServletRequest)this.servletRequest;
/* 121 */     StringBuilder sb = new StringBuilder();
/* 122 */     sb.append("[").append(httpRequest.getContextPath());
/* 123 */     sb.append(":cookies=").append(httpRequest.getCookies()).append(":headers=");
/*     */ 
/* 125 */     Enumeration en = httpRequest.getHeaderNames();
/* 126 */     while (en.hasMoreElements())
/*     */     {
/* 128 */       String headerName = (String)en.nextElement();
/* 129 */       sb.append(headerName).append("=");
/* 130 */       if (!headerName.contains("authorization"))
/* 131 */         sb.append(httpRequest.getHeader(headerName)).append(",");
/*     */     }
/* 133 */     sb.append("]");
/*     */ 
/* 135 */     sb.append("[parameters=");
/* 136 */     Enumeration enparam = httpRequest.getParameterNames();
/* 137 */     while (enparam.hasMoreElements())
/*     */     {
/* 139 */       String paramName = (String)enparam.nextElement();
/* 140 */       String[] paramValues = httpRequest.getParameterValues(paramName);
/* 141 */       int len = paramValues != null ? paramValues.length : 0;
/* 142 */       for (int i = 0; i < len; i++)
/* 143 */         sb.append(paramValues[i]).append("::");
/* 144 */       sb.append(",");
/*     */     }
/* 146 */     sb.append("][attributes=");
/*     */ 
/* 148 */     Enumeration enu = httpRequest.getAttributeNames();
/* 149 */     while (enu.hasMoreElements())
/*     */     {
/* 151 */       String attrName = (String)enu.nextElement();
/* 152 */       sb.append(attrName).append("=");
/* 153 */       sb.append(httpRequest.getAttribute(attrName)).append(",");
/*     */     }
/* 155 */     sb.append("]");
/* 156 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.resources.WebResource
 * JD-Core Version:    0.6.0
 */