/*     */ package org.jboss.security.authorization.modules.web;
/*     */ 
/*     */ import com.sun.xacml.Indenter;
/*     */ import com.sun.xacml.attr.AnyURIAttribute;
/*     */ import com.sun.xacml.attr.StringAttribute;
/*     */ import com.sun.xacml.attr.TimeAttribute;
/*     */ import com.sun.xacml.ctx.Attribute;
/*     */ import com.sun.xacml.ctx.RequestCtx;
/*     */ import com.sun.xacml.ctx.Subject;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.net.URI;
/*     */ import java.security.Principal;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class WebXACMLUtil
/*     */ {
/*  57 */   private static Logger log = Logger.getLogger(WebXACMLUtil.class);
/*  58 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public RequestCtx createXACMLRequest(HttpServletRequest request, AuthorizationManager authzManager, Set<Principal> roles)
/*     */     throws Exception
/*     */   {
/*  68 */     if (request == null)
/*  69 */       throw new IllegalArgumentException("Http Request is null");
/*  70 */     if (authzManager == null)
/*  71 */       throw new IllegalArgumentException("Authorization Manager is null");
/*  72 */     String httpMethod = request.getMethod();
/*  73 */     String action = "GET".equals(httpMethod) ? "read" : "write";
/*     */ 
/*  76 */     String actionURIBase = "urn:oasis:names:tc:xacml:2.0:request-param:attribute:";
/*     */ 
/*  78 */     RequestCtx requestCtx = null;
/*  79 */     Principal principal = request.getUserPrincipal();
/*  80 */     String username = principal.getName();
/*     */ 
/*  82 */     URI subjectAttrUri = new URI("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
/*  83 */     Attribute subjectAttr = new Attribute(subjectAttrUri, null, null, new StringAttribute(username));
/*     */ 
/*  85 */     Set subjectAttrSet = new HashSet();
/*  86 */     subjectAttrSet.add(subjectAttr);
/*  87 */     subjectAttrSet.addAll(getXACMLRoleSet(roles));
/*     */ 
/*  89 */     Set subjectSet = new HashSet();
/*  90 */     subjectSet.add(new Subject(subjectAttrSet));
/*     */ 
/*  93 */     URI resourceUri = new URI("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
/*  94 */     Attribute resourceAttr = new Attribute(resourceUri, null, null, new AnyURIAttribute(new URI(request.getRequestURI())));
/*     */ 
/*  96 */     Set resourceSet = new HashSet();
/*  97 */     resourceSet.add(resourceAttr);
/*     */ 
/* 100 */     Set actionSet = new HashSet();
/* 101 */     actionSet.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:action:action-id"), null, null, new StringAttribute(action)));
/*     */ 
/* 104 */     Enumeration enumer = request.getParameterNames();
/* 105 */     while (enumer.hasMoreElements())
/*     */     {
/* 107 */       String paramName = (String)enumer.nextElement();
/* 108 */       String paramValue = request.getParameter(paramName);
/* 109 */       URI actionUri = new URI(actionURIBase + paramName);
/* 110 */       Attribute actionAttr = new Attribute(actionUri, null, null, new StringAttribute(paramValue));
/*     */ 
/* 112 */       actionSet.add(actionAttr);
/*     */     }
/*     */ 
/* 115 */     Set environSet = new HashSet();
/*     */ 
/* 117 */     URI currentTimeUri = new URI("urn:oasis:names:tc:xacml:1.0:environment:current-time");
/* 118 */     Attribute currentTimeAttr = new Attribute(currentTimeUri, null, null, new TimeAttribute());
/*     */ 
/* 120 */     environSet.add(currentTimeAttr);
/*     */ 
/* 123 */     requestCtx = new RequestCtx(subjectSet, resourceSet, actionSet, environSet);
/*     */ 
/* 125 */     if (this.trace)
/*     */     {
/* 127 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 128 */       requestCtx.encode(baos, new Indenter());
/* 129 */       log.trace("XACML Request:" + baos.toString());
/* 130 */       baos.close();
/*     */     }
/* 132 */     return requestCtx;
/*     */   }
/*     */ 
/*     */   private Set<Attribute> getXACMLRoleSet(Set<Principal> roles) throws Exception
/*     */   {
/* 137 */     URI roleURI = new URI("urn:oasis:names:tc:xacml:2.0:subject:role");
/*     */ 
/* 139 */     Set roleset = new HashSet();
/* 140 */     Iterator iter = roles != null ? roles.iterator() : null;
/* 141 */     while ((iter != null) && (iter.hasNext()))
/*     */     {
/* 143 */       Principal role = (Principal)iter.next();
/* 144 */       if ((role instanceof SimplePrincipal))
/*     */       {
/* 146 */         SimplePrincipal sp = (SimplePrincipal)role;
/* 147 */         Attribute roleAttr = new Attribute(roleURI, null, null, new StringAttribute(sp.getName()));
/*     */ 
/* 149 */         roleset.add(roleAttr);
/*     */       }
/*     */     }
/* 152 */     return roleset;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.modules.web.WebXACMLUtil
 * JD-Core Version:    0.6.0
 */