/*     */ package org.jboss.security.authorization.modules.ejb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AnybodyPrincipal;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ import org.jboss.security.SecurityRoleRef;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.jboss.security.authorization.PolicyRegistration;
/*     */ import org.jboss.security.authorization.Resource;
/*     */ import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
/*     */ import org.jboss.security.authorization.resources.EJBResource;
/*     */ 
/*     */ public class EJBPolicyModuleDelegate extends AuthorizationModuleDelegate
/*     */ {
/*  57 */   private String ejbName = null;
/*  58 */   private Method ejbMethod = null;
/*  59 */   private Principal ejbPrincipal = null;
/*  60 */   private Set<Principal> methodRoles = null;
/*  61 */   private String methodInterface = null;
/*  62 */   private RunAs callerRunAs = null;
/*  63 */   private String roleName = null;
/*  64 */   private Boolean roleRefCheck = Boolean.FALSE;
/*  65 */   private Set<SecurityRoleRef> securityRoleReferences = null;
/*     */ 
/*     */   public EJBPolicyModuleDelegate()
/*     */   {
/*  69 */     log = Logger.getLogger(getClass());
/*  70 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public int authorize(Resource resource)
/*     */   {
/*  78 */     if (!(resource instanceof EJBResource)) {
/*  79 */       throw new IllegalArgumentException("resource is not an EJBResource");
/*     */     }
/*  81 */     EJBResource ejbResource = (EJBResource)resource;
/*     */ 
/*  84 */     Map map = resource.getMap();
/*  85 */     if (map == null) {
/*  86 */       throw new IllegalStateException("Map from the Resource is null");
/*     */     }
/*  88 */     AuthorizationManager am = (AuthorizationManager)map.get("authorizationManager");
/*  89 */     if (am == null)
/*  90 */       throw new IllegalStateException("Authorization Manager is null");
/*  91 */     if ((am instanceof PolicyRegistration)) {
/*  92 */       this.policyRegistration = ((PolicyRegistration)am);
/*     */     }
/*     */ 
/* 102 */     this.roleName = ((String)map.get("roleName"));
/* 103 */     this.roleRefCheck = ((Boolean)map.get("roleRefPermissionCheck"));
/*     */ 
/* 105 */     this.callerRunAs = ejbResource.getCallerRunAsIdentity();
/* 106 */     this.ejbMethod = ejbResource.getEjbMethod();
/* 107 */     this.ejbName = ejbResource.getEjbName();
/* 108 */     this.ejbPrincipal = ejbResource.getPrincipal();
/* 109 */     this.methodInterface = ejbResource.getEjbMethodInterface();
/* 110 */     this.methodRoles = ejbResource.getMethodRoles();
/* 111 */     this.securityRoleReferences = ejbResource.getSecurityRoleReferences();
/*     */ 
/* 113 */     if (this.roleRefCheck == Boolean.TRUE) {
/* 114 */       return checkRoleRef();
/*     */     }
/* 116 */     return process();
/*     */   }
/*     */ 
/*     */   private int process()
/*     */   {
/* 128 */     boolean allowed = true;
/*     */ 
/* 131 */     if (this.methodRoles == null)
/*     */     {
/* 133 */       if (this.ejbMethod == null)
/* 134 */         throw new IllegalStateException("ejbMethod is null");
/* 135 */       String method = this.ejbMethod.getName();
/* 136 */       String msg = "No method permissions assigned to method=" + method + ", interface=" + this.methodInterface;
/*     */ 
/* 138 */       if (this.trace)
/* 139 */         log.trace("Exception:" + msg);
/* 140 */       allowed = false;
/*     */     }
/* 142 */     else if (this.trace)
/*     */     {
/* 144 */       log.trace("method=" + this.ejbMethod + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles);
/*     */     }
/*     */ 
/* 149 */     if (!this.methodRoles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL))
/*     */     {
/* 152 */       if (this.callerRunAs == null)
/*     */       {
/* 154 */         AuthorizationManager am = (AuthorizationManager)this.policyRegistration;
/*     */ 
/* 157 */         if (!am.doesUserHaveRole(this.ejbPrincipal, this.methodRoles))
/*     */         {
/* 159 */           if (this.ejbMethod == null) {
/* 160 */             throw new IllegalStateException("ejbMethod is null");
/*     */           }
/* 162 */           Set userRoles = am.getUserRoles(this.ejbPrincipal);
/* 163 */           String method = this.ejbMethod.getName();
/* 164 */           String msg = "Insufficient method permissions, principal=" + this.ejbPrincipal + ", ejbName=" + this.ejbName + ", method=" + method + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles + ", principalRoles=" + userRoles;
/*     */ 
/* 168 */           if (this.trace)
/* 169 */             log.trace("Exception:" + msg);
/* 170 */           allowed = false;
/*     */         }
/*     */ 
/*     */       }
/* 177 */       else if ((this.callerRunAs instanceof RunAsIdentity))
/*     */       {
/* 179 */         RunAsIdentity callerRunAsIdentity = (RunAsIdentity)this.callerRunAs;
/*     */ 
/* 181 */         if (!callerRunAsIdentity.doesUserHaveRole(this.methodRoles))
/*     */         {
/* 183 */           String method = this.ejbMethod.getName();
/* 184 */           String msg = "Insufficient method permissions, principal=" + this.ejbPrincipal + ", ejbName=" + this.ejbName + ", method=" + method + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles + ", runAsRoles=" + callerRunAsIdentity.getRunAsRoles();
/*     */ 
/* 189 */           if (this.trace)
/* 190 */             log.trace("Exception:" + msg);
/* 191 */           allowed = false;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 197 */     return allowed ? 1 : -1;
/*     */   }
/*     */ 
/*     */   private int checkRoleRef()
/*     */   {
/* 202 */     AuthorizationManager am = (AuthorizationManager)this.policyRegistration;
/*     */ 
/* 204 */     if ((this.ejbPrincipal == null) && (this.callerRunAs == null))
/*     */     {
/* 206 */       if (this.trace)
/* 207 */         log.trace("ejbPrincipal = null,callerRunAsIdentity = null => DENY");
/* 208 */       return -1;
/*     */     }
/*     */ 
/* 219 */     boolean matchFound = false;
/* 220 */     Iterator it = this.securityRoleReferences.iterator();
/* 221 */     while (it.hasNext())
/*     */     {
/* 223 */       SecurityRoleRef meta = (SecurityRoleRef)it.next();
/* 224 */       if (meta.getName().equals(this.roleName))
/*     */       {
/* 226 */         this.roleName = meta.getLink();
/* 227 */         matchFound = true;
/* 228 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 232 */     if (!matchFound) {
/* 233 */       log.trace("no match found for security role " + this.roleName + " in the deployment descriptor for ejb " + this.ejbName);
/*     */     }
/*     */ 
/* 236 */     HashSet set = new HashSet();
/* 237 */     set.add(new SimplePrincipal(this.roleName));
/*     */ 
/* 239 */     boolean allowed = false;
/* 240 */     if (this.callerRunAs == null) {
/* 241 */       allowed = am.doesUserHaveRole(this.ejbPrincipal, set);
/*     */     }
/* 244 */     else if ((this.callerRunAs instanceof RunAsIdentity))
/*     */     {
/* 246 */       RunAsIdentity callerRunAsIdentity = (RunAsIdentity)this.callerRunAs;
/* 247 */       allowed = callerRunAsIdentity.doesUserHaveRole(set);
/*     */     }
/*     */ 
/* 250 */     return allowed ? 1 : -1;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.modules.ejb.EJBPolicyModuleDelegate
 * JD-Core Version:    0.6.0
 */