/*     */ package org.jboss.security.authorization.modules.ejb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.CodeSource;
/*     */ import java.security.Permission;
/*     */ import java.security.Policy;
/*     */ import java.security.Principal;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.EJBMethodPermission;
/*     */ import javax.security.jacc.EJBRoleRefPermission;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.SimpleGroup;
/*     */ import org.jboss.security.authorization.PolicyRegistration;
/*     */ import org.jboss.security.authorization.Resource;
/*     */ import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
/*     */ import org.jboss.security.authorization.resources.EJBResource;
/*     */ 
/*     */ public class EJBJACCPolicyModuleDelegate extends AuthorizationModuleDelegate
/*     */ {
/*  63 */   private String ejbName = null;
/*  64 */   private Method ejbMethod = null;
/*  65 */   private Subject callerSubject = null;
/*  66 */   private String methodInterface = null;
/*  67 */   private CodeSource ejbCS = null;
/*  68 */   private String roleName = null;
/*  69 */   private Boolean roleRefCheck = Boolean.FALSE;
/*  70 */   private Group securityContextRoles = null;
/*     */ 
/*     */   public EJBJACCPolicyModuleDelegate()
/*     */   {
/*  74 */     log = Logger.getLogger(getClass());
/*  75 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public int authorize(Resource resource)
/*     */   {
/*  83 */     if (!(resource instanceof EJBResource)) {
/*  84 */       throw new IllegalArgumentException("resource is not an EJBResource");
/*     */     }
/*  86 */     EJBResource ejbResource = (EJBResource)resource;
/*     */ 
/*  89 */     Map map = resource.getMap();
/*  90 */     if (map == null) {
/*  91 */       throw new IllegalStateException("Map from the Resource is null");
/*     */     }
/*  93 */     AuthorizationManager am = (AuthorizationManager)map.get("authorizationManager");
/*  94 */     if (am == null)
/*  95 */       throw new IllegalStateException("Authorization Manager is null");
/*  96 */     if ((am instanceof PolicyRegistration)) {
/*  97 */       this.policyRegistration = ((PolicyRegistration)am);
/*     */     }
/*     */ 
/* 107 */     this.callerSubject = ejbResource.getCallerSubject();
/* 108 */     this.ejbCS = ejbResource.getCodeSource();
/* 109 */     this.ejbMethod = ejbResource.getEjbMethod();
/* 110 */     this.ejbName = ejbResource.getEjbName();
/* 111 */     this.methodInterface = ejbResource.getEjbMethodInterface();
/*     */ 
/* 113 */     this.roleName = ((String)map.get("roleName"));
/*     */ 
/* 115 */     if (am != null)
/*     */     {
/* 117 */       Principal ejbPrincipal = (Principal)map.get("ejb.principal");
/* 118 */       Set roleset = am.getUserRoles(ejbPrincipal);
/* 119 */       this.securityContextRoles = getGroupFromRoleSet(roleset);
/*     */     }
/* 121 */     this.roleRefCheck = ((Boolean)map.get("roleRefPermissionCheck"));
/* 122 */     if (this.roleRefCheck == Boolean.TRUE) {
/* 123 */       return checkRoleRef();
/*     */     }
/* 125 */     return process();
/*     */   }
/*     */ 
/*     */   private int process()
/*     */   {
/* 137 */     EJBMethodPermission methodPerm = new EJBMethodPermission(this.ejbName, this.methodInterface, this.ejbMethod);
/*     */ 
/* 139 */     boolean policyDecision = checkWithPolicy(methodPerm);
/* 140 */     if (!policyDecision)
/*     */     {
/* 142 */       String msg = "Denied: " + methodPerm + ", caller=" + this.callerSubject;
/* 143 */       if (this.trace)
/* 144 */         log.trace("EJB Jacc Delegate:" + msg);
/*     */     }
/* 146 */     return policyDecision ? 1 : -1;
/*     */   }
/*     */ 
/*     */   private int checkRoleRef()
/*     */   {
/* 152 */     EJBRoleRefPermission ejbRoleRefPerm = new EJBRoleRefPermission(this.ejbName, this.roleName);
/* 153 */     boolean policyDecision = checkWithPolicy(ejbRoleRefPerm);
/* 154 */     if (!policyDecision)
/*     */     {
/* 156 */       String msg = "Denied: " + ejbRoleRefPerm + ", caller=" + this.callerSubject;
/* 157 */       if (this.trace)
/* 158 */         log.trace("EJB Jacc Delegate:" + msg);
/*     */     }
/* 160 */     return policyDecision ? 1 : -1;
/*     */   }
/*     */ 
/*     */   private Principal[] getPrincipalSet()
/*     */   {
/* 165 */     Principal[] principals = null;
/*     */ 
/* 170 */     if (this.trace)
/* 171 */       log.trace("Roles used for checking from the context:" + this.securityContextRoles);
/* 172 */     if (this.securityContextRoles != null)
/*     */     {
/* 174 */       Set principalsSet = new HashSet();
/* 175 */       Enumeration en = this.securityContextRoles.members();
/* 176 */       while (en.hasMoreElements())
/* 177 */         principalsSet.add(en.nextElement());
/* 178 */       principals = new Principal[principalsSet.size()];
/* 179 */       principalsSet.toArray(principals);
/*     */     }
/* 181 */     return principals;
/*     */   }
/*     */ 
/*     */   private boolean checkWithPolicy(Permission ejbPerm)
/*     */   {
/* 186 */     Principal[] principals = getPrincipalSet();
/* 187 */     ProtectionDomain pd = new ProtectionDomain(this.ejbCS, null, null, principals);
/* 188 */     return Policy.getPolicy().implies(pd, ejbPerm);
/*     */   }
/*     */ 
/*     */   private Group getGroupFromRoleSet(Set<Principal> roleset)
/*     */   {
/* 193 */     Group gp = new SimpleGroup("Roles");
/* 194 */     for (Principal p : roleset)
/*     */     {
/* 196 */       gp.addMember(p);
/*     */     }
/* 198 */     return gp;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.modules.ejb.EJBJACCPolicyModuleDelegate
 * JD-Core Version:    0.6.0
 */