/*     */ package org.jboss.security.authorization.modules;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.authorization.AuthorizationException;
/*     */ import org.jboss.security.authorization.AuthorizationModule;
/*     */ import org.jboss.security.authorization.Resource;
/*     */ import org.jboss.security.authorization.ResourceType;
/*     */ 
/*     */ public abstract class AbstractAuthorizationModule
/*     */   implements AuthorizationModule
/*     */ {
/*  48 */   protected Subject subject = null;
/*  49 */   protected CallbackHandler handler = null;
/*  50 */   protected Map sharedState = null;
/*  51 */   protected Map options = null;
/*     */ 
/*  53 */   protected Logger log = null;
/*     */ 
/*  56 */   protected Map<ResourceType, String> delegateMap = new HashMap();
/*     */ 
/*     */   public abstract int authorize(Resource paramResource);
/*     */ 
/*     */   public boolean abort()
/*     */     throws AuthorizationException
/*     */   {
/*  68 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean commit()
/*     */     throws AuthorizationException
/*     */   {
/*  76 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean destroy()
/*     */   {
/*  84 */     this.subject = null;
/*  85 */     this.handler = null;
/*  86 */     this.sharedState = null;
/*  87 */     this.options = null;
/*  88 */     return true;
/*     */   }
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)
/*     */   {
/*  97 */     this.subject = subject;
/*  98 */     this.handler = handler;
/*  99 */     this.sharedState = sharedState;
/* 100 */     this.options = options;
/*     */ 
/* 102 */     if (options != null)
/*     */     {
/* 104 */       String commaSeparatedDelegates = (String)options.get("delegateMap");
/* 105 */       if ((commaSeparatedDelegates != null) && (commaSeparatedDelegates.length() > 0))
/* 106 */         populateDelegateMap(commaSeparatedDelegates);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 115 */     StringBuffer buf = new StringBuffer("Name=" + getClass().getName());
/* 116 */     buf.append(":subject=" + this.subject);
/* 117 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   protected int invokeDelegate(Resource resource)
/*     */   {
/* 127 */     int authorizationDecision = -1;
/*     */ 
/* 129 */     ResourceType layer = resource.getLayer();
/* 130 */     String delegateStr = (String)this.delegateMap.get(layer);
/* 131 */     if (delegateStr == null)
/* 132 */       throw new IllegalStateException("Delegate is missing for layer=" + layer);
/* 133 */     AuthorizationModuleDelegate delegate = null;
/*     */     try
/*     */     {
/* 136 */       delegate = getDelegate(delegateStr);
/* 137 */       authorizationDecision = delegate.authorize(resource);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 141 */       this.log.debug("Error with delegate:", e);
/* 142 */       IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
/* 143 */       ise.initCause(e);
/* 144 */       throw ise;
/*     */     }
/* 146 */     return authorizationDecision;
/*     */   }
/*     */ 
/*     */   protected AuthorizationModuleDelegate getDelegate(String delegateStr)
/*     */     throws Exception
/*     */   {
/* 158 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/* 159 */     Class clazz = tcl.loadClass(delegateStr);
/* 160 */     return (AuthorizationModuleDelegate)clazz.newInstance();
/*     */   }
/*     */ 
/*     */   protected void populateDelegateMap(String commaSeparatedDelegates)
/*     */   {
/* 169 */     StringTokenizer st = new StringTokenizer(commaSeparatedDelegates, ",");
/* 170 */     while (st.hasMoreTokens())
/*     */     {
/* 172 */       String keyPair = st.nextToken();
/* 173 */       StringTokenizer keyst = new StringTokenizer(keyPair, "=");
/* 174 */       if (keyst.countTokens() != 2)
/* 175 */         throw new IllegalStateException("DelegateMap entry invalid:" + keyPair);
/* 176 */       String key = keyst.nextToken();
/* 177 */       String value = keyst.nextToken();
/* 178 */       this.delegateMap.put(ResourceType.valueOf(key), value);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.modules.AbstractAuthorizationModule
 * JD-Core Version:    0.6.0
 */