/*    */ package org.jboss.security.authorization.config;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.security.auth.login.ModuleOption;
/*    */ import org.jboss.security.config.ControlFlag;
/*    */ import org.jboss.xb.binding.GenericValueContainer;
/*    */ 
/*    */ public class AuthorizationConfigEntryHolder
/*    */   implements GenericValueContainer
/*    */ {
/* 43 */   private Map moduleOptions = new HashMap();
/* 44 */   String moduleName = null;
/* 45 */   ControlFlag controlFlag = ControlFlag.REQUIRED;
/*    */ 
/*    */   public void addChild(QName name, Object value)
/*    */   {
/* 49 */     if ("code".equals(name.getLocalPart()))
/*    */     {
/* 51 */       this.moduleName = ((String)value);
/*    */     }
/* 53 */     if ("flag".equals(name.getLocalPart()))
/*    */     {
/* 55 */       String tempVal = (String)value;
/* 56 */       if ("optional".equals(tempVal)) {
/* 57 */         this.controlFlag = ControlFlag.OPTIONAL;
/*    */       }
/* 59 */       else if ("requisite".equals(tempVal)) {
/* 60 */         this.controlFlag = ControlFlag.REQUISITE;
/*    */       }
/* 62 */       else if ("sufficient".equals(tempVal))
/* 63 */         this.controlFlag = ControlFlag.SUFFICIENT;
/*    */     }
/* 65 */     if ((value instanceof ModuleOption))
/*    */     {
/* 67 */       ModuleOption mo = (ModuleOption)value;
/* 68 */       this.moduleOptions.put(mo.getName(), mo.getValue());
/*    */     }
/*    */   }
/*    */ 
/*    */   public void addOption(ModuleOption option)
/*    */   {
/* 74 */     this.moduleOptions.put(option.getName(), option.getValue());
/*    */   }
/*    */ 
/*    */   public AuthorizationModuleEntry getEntry()
/*    */   {
/* 79 */     return (AuthorizationModuleEntry)instantiate();
/*    */   }
/*    */ 
/*    */   public Object instantiate()
/*    */   {
/* 84 */     AuthorizationModuleEntry entry = new AuthorizationModuleEntry(this.moduleName, this.moduleOptions);
/* 85 */     entry.setControlFlag(this.controlFlag);
/* 86 */     return entry;
/*    */   }
/*    */ 
/*    */   public Class getTargetClass()
/*    */   {
/* 91 */     return AuthorizationModuleEntry.class;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.config.AuthorizationConfigEntryHolder
 * JD-Core Version:    0.6.0
 */