/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.security.acl.Group;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class XMLLoginModule extends UsernamePasswordLoginModule
/*     */ {
/*     */   private Users users;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*     */   {
/*  80 */     super.initialize(subject, callbackHandler, sharedState, options);
/*     */     try
/*     */     {
/*  83 */       this.users = ((Users)options.get("userInfo"));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  89 */       this.log.error("Failed to load users/passwords/role files", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/* 101 */     if (this.users == null) {
/* 102 */       throw new LoginException("Missing usersInfo user/role mapping");
/*     */     }
/* 104 */     return super.login();
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets()
/*     */     throws LoginException
/*     */   {
/* 112 */     String targetUser = getUsername();
/* 113 */     Users.User user = this.users.getUser(targetUser);
/* 114 */     Group[] roleSets = new Group[0];
/* 115 */     if (user != null) {
/* 116 */       roleSets = user.getRoleSets();
/*     */     }
/* 118 */     return roleSets;
/*     */   }
/*     */ 
/*     */   protected String getUsersPassword()
/*     */   {
/* 123 */     String username = getUsername();
/* 124 */     Users.User user = this.users.getUser(username);
/* 125 */     String password = null;
/* 126 */     if (user != null)
/*     */     {
/* 128 */       password = user.getPassword();
/*     */     }
/*     */ 
/* 131 */     return password;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.XMLLoginModule
 * JD-Core Version:    0.6.0
 */