/*    */ package org.jboss.security.auth.spi;
/*    */ 
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.xb.binding.ObjectModelFactory;
/*    */ import org.jboss.xb.binding.UnmarshallingContext;
/*    */ import org.xml.sax.Attributes;
/*    */ 
/*    */ public class UsersObjectModelFactory
/*    */   implements ObjectModelFactory
/*    */ {
/* 35 */   private static Logger log = Logger.getLogger(UsersObjectModelFactory.class);
/*    */ 
/*    */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*    */   {
/* 40 */     if (!localName.equals("users"))
/*    */     {
/* 42 */       throw new IllegalStateException("Unexpected root element: was expecting 'users' but got '" + localName + "'");
/*    */     }
/* 44 */     log.trace("newRoot, root=" + root);
/* 45 */     return new Users();
/*    */   }
/*    */ 
/*    */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*    */   {
/* 50 */     return root;
/*    */   }
/*    */ 
/*    */   public void setValue(Users users, UnmarshallingContext navigator, String namespaceUri, String localName, String value)
/*    */   {
/*    */   }
/*    */ 
/*    */   public Object newChild(Users users, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*    */   {
/* 61 */     Users.User child = null;
/* 62 */     if ("user".equals(localName))
/*    */     {
/* 64 */       String name = attrs.getValue("name");
/* 65 */       child = new Users.User(name);
/* 66 */       String password = attrs.getValue("password");
/* 67 */       child.setPassword(password);
/* 68 */       String encoding = attrs.getValue("encoding");
/* 69 */       child.setEncoding(encoding);
/* 70 */       log.trace("newChild, user=" + child);
/*    */     }
/* 72 */     return child;
/*    */   }
/*    */ 
/*    */   public void addChild(Users users, Users.User user, UnmarshallingContext navigator, String namespaceURI, String localName)
/*    */   {
/* 78 */     users.addUser(user);
/*    */   }
/*    */ 
/*    */   public Object newChild(Users.User user, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*    */   {
/* 84 */     String[] roleInfo = { null, "Roles" };
/* 85 */     if ("role".equals(localName))
/*    */     {
/* 87 */       roleInfo[0] = attrs.getValue("name");
/* 88 */       roleInfo[1] = attrs.getValue("group");
/* 89 */       if (roleInfo[1] == null)
/* 90 */         roleInfo[1] = "Roles";
/*    */     }
/* 92 */     return roleInfo;
/*    */   }
/*    */ 
/*    */   public void addChild(Users.User user, String[] roleInfo, UnmarshallingContext navigator, String namespaceURI, String localName)
/*    */   {
/* 98 */     user.addRole(roleInfo[0], roleInfo[1]);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.UsersObjectModelFactory
 * JD-Core Version:    0.6.0
 */