/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.Callback;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.callback.NameCallback;
/*     */ import javax.security.auth.callback.PasswordCallback;
/*     */ import javax.security.auth.callback.UnsupportedCallbackException;
/*     */ import javax.security.auth.login.FailedLoginException;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.crypto.digest.DigestCallback;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class UsernamePasswordLoginModule extends AbstractServerLoginModule
/*     */ {
/*     */   private Principal identity;
/*     */   private char[] credential;
/*  67 */   private String hashAlgorithm = null;
/*     */ 
/*  71 */   private String hashCharset = null;
/*     */ 
/*  73 */   private String hashEncoding = null;
/*     */   private boolean ignorePasswordCase;
/*     */   private boolean hashStorePassword;
/*  80 */   private boolean hashUserPassword = true;
/*     */   private boolean legacyCreatePasswordHash;
/*     */   private Throwable validateError;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*     */   {
/* 111 */     super.initialize(subject, callbackHandler, sharedState, options);
/*     */ 
/* 115 */     this.hashAlgorithm = ((String)options.get("hashAlgorithm"));
/* 116 */     if (this.hashAlgorithm != null)
/*     */     {
/* 118 */       this.hashEncoding = ((String)options.get("hashEncoding"));
/* 119 */       if (this.hashEncoding == null)
/* 120 */         this.hashEncoding = "BASE64";
/* 121 */       this.hashCharset = ((String)options.get("hashCharset"));
/* 122 */       if (this.log.isTraceEnabled())
/*     */       {
/* 124 */         this.log.trace("Password hashing activated: algorithm = " + this.hashAlgorithm + ", encoding = " + this.hashEncoding + ", charset = " + (this.hashCharset == null ? "{default}" : this.hashCharset) + ", callback = " + options.get("digestCallback") + ", storeCallback = " + options.get("storeDigestCallback"));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 132 */     String flag = (String)options.get("ignorePasswordCase");
/* 133 */     this.ignorePasswordCase = Boolean.valueOf(flag).booleanValue();
/* 134 */     flag = (String)options.get("hashStorePassword");
/* 135 */     this.hashStorePassword = Boolean.valueOf(flag).booleanValue();
/* 136 */     flag = (String)options.get("hashUserPassword");
/* 137 */     if (flag != null)
/* 138 */       this.hashUserPassword = Boolean.valueOf(flag).booleanValue();
/* 139 */     flag = (String)options.get("legacyCreatePasswordHash");
/* 140 */     if (flag != null)
/* 141 */       this.legacyCreatePasswordHash = Boolean.valueOf(flag).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/* 149 */     if (super.login() == true)
/*     */     {
/* 152 */       Object username = this.sharedState.get("javax.security.auth.login.name");
/* 153 */       if ((username instanceof Principal)) {
/* 154 */         this.identity = ((Principal)username);
/*     */       }
/*     */       else {
/* 157 */         String name = username.toString();
/*     */         try
/*     */         {
/* 160 */           this.identity = createIdentity(name);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 164 */           this.log.debug("Failed to create principal", e);
/* 165 */           throw new LoginException("Failed to create principal: " + e.getMessage());
/*     */         }
/*     */       }
/* 168 */       Object password = this.sharedState.get("javax.security.auth.login.password");
/* 169 */       if ((password instanceof char[])) {
/* 170 */         this.credential = ((char[])(char[])password);
/* 171 */       } else if (password != null)
/*     */       {
/* 173 */         String tmp = password.toString();
/* 174 */         this.credential = tmp.toCharArray();
/*     */       }
/* 176 */       return true;
/*     */     }
/*     */ 
/* 179 */     this.loginOk = false;
/* 180 */     String[] info = getUsernameAndPassword();
/* 181 */     String username = info[0];
/* 182 */     String password = info[1];
/* 183 */     if ((username == null) && (password == null))
/*     */     {
/* 185 */       this.identity = this.unauthenticatedIdentity;
/* 186 */       this.log.trace("Authenticating as unauthenticatedIdentity=" + this.identity);
/*     */     }
/*     */ 
/* 189 */     if (this.identity == null)
/*     */     {
/*     */       try
/*     */       {
/* 193 */         this.identity = createIdentity(username);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 197 */         this.log.debug("Failed to create principal", e);
/* 198 */         throw new LoginException("Failed to create principal: " + e.getMessage());
/*     */       }
/*     */ 
/* 202 */       if ((this.hashAlgorithm != null) && (this.hashUserPassword == true)) {
/* 203 */         password = createPasswordHash(username, password, "digestCallback");
/*     */       }
/* 205 */       String expectedPassword = getUsersPassword();
/*     */ 
/* 207 */       if ((this.hashAlgorithm != null) && (this.hashStorePassword == true))
/* 208 */         expectedPassword = createPasswordHash(username, expectedPassword, "storeDigestCallback");
/* 209 */       if (!validatePassword(password, expectedPassword))
/*     */       {
/* 211 */         Throwable ex = getValidateError();
/* 212 */         FailedLoginException fle = new FailedLoginException("Password Incorrect/Password Required");
/* 213 */         if (ex != null)
/*     */         {
/* 215 */           this.log.debug("Bad password for username=" + username, ex);
/* 216 */           fle.initCause(ex);
/*     */         }
/*     */         else
/*     */         {
/* 220 */           this.log.debug("Bad password for username=" + username);
/*     */         }
/* 222 */         throw fle;
/*     */       }
/*     */     }
/*     */ 
/* 226 */     if (getUseFirstPass() == true)
/*     */     {
/* 228 */       this.sharedState.put("javax.security.auth.login.name", username);
/* 229 */       this.sharedState.put("javax.security.auth.login.password", this.credential);
/*     */     }
/* 231 */     this.loginOk = true;
/* 232 */     this.log.trace("User '" + this.identity + "' authenticated, loginOk=" + this.loginOk);
/* 233 */     return true;
/*     */   }
/*     */ 
/*     */   protected Principal getIdentity()
/*     */   {
/* 238 */     return this.identity;
/*     */   }
/*     */ 
/*     */   protected Principal getUnauthenticatedIdentity() {
/* 242 */     return this.unauthenticatedIdentity;
/*     */   }
/*     */ 
/*     */   protected Object getCredentials()
/*     */   {
/* 247 */     return this.credential;
/*     */   }
/*     */ 
/*     */   protected String getUsername() {
/* 251 */     String username = null;
/* 252 */     if (getIdentity() != null)
/* 253 */       username = getIdentity().getName();
/* 254 */     return username;
/*     */   }
/*     */ 
/*     */   protected String[] getUsernameAndPassword()
/*     */     throws LoginException
/*     */   {
/* 264 */     String[] info = { null, null };
/*     */ 
/* 266 */     if (this.callbackHandler == null)
/*     */     {
/* 268 */       throw new LoginException("Error: no CallbackHandler available to collect authentication information");
/*     */     }
/*     */ 
/* 272 */     NameCallback nc = new NameCallback("User name: ", "guest");
/* 273 */     PasswordCallback pc = new PasswordCallback("Password: ", false);
/* 274 */     Callback[] callbacks = { nc, pc };
/* 275 */     String username = null;
/* 276 */     String password = null;
/*     */     try
/*     */     {
/* 279 */       this.callbackHandler.handle(callbacks);
/* 280 */       username = nc.getName();
/* 281 */       char[] tmpPassword = pc.getPassword();
/* 282 */       if (tmpPassword != null)
/*     */       {
/* 284 */         this.credential = new char[tmpPassword.length];
/* 285 */         System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
/* 286 */         pc.clearPassword();
/* 287 */         password = new String(this.credential);
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 292 */       LoginException le = new LoginException("Failed to get username/password");
/* 293 */       le.initCause(e);
/* 294 */       throw le;
/*     */     }
/*     */     catch (UnsupportedCallbackException e)
/*     */     {
/* 298 */       LoginException le = new LoginException("CallbackHandler does not support: " + e.getCallback());
/* 299 */       le.initCause(e);
/* 300 */       throw le;
/*     */     }
/* 302 */     info[0] = username;
/* 303 */     info[1] = password;
/* 304 */     return info;
/*     */   }
/*     */ 
/*     */   protected String createPasswordHash(String username, String password, String digestOption)
/*     */     throws LoginException
/*     */   {
/* 341 */     if (this.legacyCreatePasswordHash)
/*     */     {
/*     */       try
/*     */       {
/* 346 */         Class[] sig = { String.class, String.class };
/* 347 */         Method createPasswordHash = getClass().getMethod("createPasswordHash", sig);
/* 348 */         Object[] args = { username, password };
/* 349 */         String passwordHash = (String)createPasswordHash.invoke(this, args);
/* 350 */         return passwordHash;
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/* 354 */         LoginException le = new LoginException("Failed to delegate createPasswordHash");
/* 355 */         le.initCause(e.getTargetException());
/* 356 */         throw le;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 360 */         LoginException le = new LoginException("Failed to delegate createPasswordHash");
/* 361 */         le.initCause(e);
/* 362 */         throw le;
/*     */       }
/*     */     }
/*     */ 
/* 366 */     DigestCallback callback = null;
/* 367 */     String callbackClassName = (String)this.options.get(digestOption);
/* 368 */     if (callbackClassName != null)
/*     */     {
/*     */       try
/*     */       {
/* 372 */         ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 373 */         Class callbackClass = loader.loadClass(callbackClassName);
/* 374 */         callback = (DigestCallback)callbackClass.newInstance();
/* 375 */         if (this.log.isTraceEnabled())
/* 376 */           this.log.trace("Created DigestCallback: " + callback);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 380 */         if (this.log.isTraceEnabled())
/* 381 */           this.log.trace("Failed to load DigestCallback", e);
/* 382 */         SecurityException ex = new SecurityException("Failed to load DigestCallback");
/* 383 */         ex.initCause(e);
/* 384 */         throw ex;
/*     */       }
/* 386 */       Map tmp = new HashMap();
/* 387 */       tmp.putAll(this.options);
/* 388 */       tmp.put("javax.security.auth.login.name", username);
/* 389 */       tmp.put("javax.security.auth.login.password", password);
/*     */ 
/* 391 */       callback.init(tmp);
/*     */ 
/* 393 */       Callback[] callbacks = (Callback[])(Callback[])tmp.get("callbacks");
/* 394 */       if (callbacks != null)
/*     */       {
/*     */         try
/*     */         {
/* 398 */           this.callbackHandler.handle(callbacks);
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 402 */           LoginException le = new LoginException(digestOption + " callback failed");
/* 403 */           le.initCause(e);
/* 404 */           throw le;
/*     */         }
/*     */         catch (UnsupportedCallbackException e)
/*     */         {
/* 408 */           LoginException le = new LoginException(digestOption + " callback failed");
/* 409 */           le.initCause(e);
/* 410 */           throw le;
/*     */         }
/*     */       }
/*     */     }
/* 414 */     String passwordHash = Util.createPasswordHash(this.hashAlgorithm, this.hashEncoding, this.hashCharset, username, password, callback);
/*     */ 
/* 416 */     return passwordHash;
/*     */   }
/*     */ 
/*     */   protected Throwable getValidateError()
/*     */   {
/* 426 */     return this.validateError;
/*     */   }
/*     */ 
/*     */   protected void setValidateError(Throwable validateError)
/*     */   {
/* 435 */     this.validateError = validateError;
/*     */   }
/*     */ 
/*     */   protected boolean validatePassword(String inputPassword, String expectedPassword)
/*     */   {
/* 446 */     if ((inputPassword == null) || (expectedPassword == null))
/* 447 */       return false;
/* 448 */     boolean valid = false;
/* 449 */     if (this.ignorePasswordCase == true)
/* 450 */       valid = inputPassword.equalsIgnoreCase(expectedPassword);
/*     */     else
/* 452 */       valid = inputPassword.equals(expectedPassword);
/* 453 */     return valid;
/*     */   }
/*     */ 
/*     */   protected abstract String getUsersPassword()
/*     */     throws LoginException;
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.UsernamePasswordLoginModule
 * JD-Core Version:    0.6.0
 */