/*    */ package org.jboss.security.auth.spi;
/*    */ 
/*    */ import java.util.Map;
/*    */ import javax.security.auth.Subject;
/*    */ import javax.security.auth.callback.CallbackHandler;
/*    */ import javax.security.auth.spi.LoginModule;
/*    */ import org.jboss.security.RunAsIdentity;
/*    */ import org.jboss.security.SecurityAssociation;
/*    */ 
/*    */ public class RunAsLoginModule
/*    */   implements LoginModule
/*    */ {
/*    */   private String roleName;
/*    */   private String principalName;
/*    */   private boolean pushedRole;
/*    */ 
/*    */   public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)
/*    */   {
/* 51 */     this.roleName = ((String)options.get("roleName"));
/* 52 */     if (this.roleName == null) {
/* 53 */       this.roleName = "nobody";
/*    */     }
/* 55 */     this.principalName = ((String)options.get("principalName"));
/* 56 */     if (this.principalName == null)
/* 57 */       this.principalName = "nobody";
/*    */   }
/*    */ 
/*    */   public boolean login()
/*    */   {
/* 65 */     RunAsIdentity runAsRole = new RunAsIdentity(this.roleName, this.principalName);
/* 66 */     SecurityAssociation.pushRunAsIdentity(runAsRole);
/* 67 */     this.pushedRole = true;
/* 68 */     return true;
/*    */   }
/*    */ 
/*    */   public boolean commit()
/*    */   {
/* 75 */     return abort();
/*    */   }
/*    */ 
/*    */   public boolean abort()
/*    */   {
/* 83 */     if (!this.pushedRole) {
/* 84 */       return false;
/*    */     }
/* 86 */     SecurityAssociation.popRunAsIdentity();
/* 87 */     return true;
/*    */   }
/*    */ 
/*    */   public boolean logout()
/*    */   {
/* 92 */     return true;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.RunAsLoginModule
 * JD-Core Version:    0.6.0
 */