/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ 
/*     */ public class RoleMappingLoginModule extends AbstractServerLoginModule
/*     */ {
/*  54 */   private static Logger log = Logger.getLogger(RoleMappingLoginModule.class);
/*  55 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*  60 */   protected boolean REPLACE_ROLE = false;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)
/*     */   {
/*  69 */     super.initialize(subject, handler, sharedState, options);
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/*  77 */     if (super.login() == true) {
/*  78 */       return true;
/*     */     }
/*  80 */     this.loginOk = true;
/*  81 */     return true;
/*     */   }
/*     */ 
/*     */   protected Principal getIdentity()
/*     */   {
/*  90 */     Iterator iter = this.subject.getPrincipals().iterator();
/*  91 */     while (iter.hasNext())
/*     */     {
/*  93 */       Principal p = (Principal)iter.next();
/*  94 */       if (!(p instanceof Group))
/*  95 */         return p;
/*     */     }
/*  97 */     return null;
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets()
/*     */     throws LoginException
/*     */   {
/* 105 */     String rep = (String)this.options.get("replaceRole");
/* 106 */     if ("true".equalsIgnoreCase(rep)) {
/* 107 */       this.REPLACE_ROLE = true;
/*     */     }
/*     */ 
/* 110 */     String propFileName = (String)this.options.get("rolesProperties");
/* 111 */     if (propFileName == null) {
/* 112 */       throw new IllegalStateException("rolesProperties option needs to be provided");
/*     */     }
/* 114 */     propFileName = StringPropertyReplacer.replaceProperties(propFileName);
/* 115 */     Group group = getExistingRolesFromSubject();
/* 116 */     if (propFileName != null)
/*     */     {
/* 118 */       Properties props = new Properties();
/*     */       try
/*     */       {
/* 121 */         props = Util.loadProperties(propFileName, log);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 125 */         if (this.trace)
/* 126 */           log.trace("Could not load properties file:" + propFileName, e);
/*     */       }
/* 128 */       if (props != null)
/*     */       {
/*     */         try
/*     */         {
/* 132 */           processRoles(group, props);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 136 */           if (this.trace) {
/* 137 */             log.trace("Could not process roles:", e);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 142 */     return new Group[] { group };
/*     */   }
/*     */ 
/*     */   private Group getExistingRolesFromSubject()
/*     */   {
/* 152 */     Iterator iter = this.subject.getPrincipals().iterator();
/* 153 */     while (iter.hasNext())
/*     */     {
/* 155 */       Principal p = (Principal)iter.next();
/* 156 */       if ((p instanceof Group))
/*     */       {
/* 158 */         Group g = (Group)p;
/* 159 */         if ("Roles".equals(g.getName()))
/* 160 */           return g;
/*     */       }
/*     */     }
/* 163 */     return null;
/*     */   }
/*     */ 
/*     */   private void processRoles(Group group, Properties props)
/*     */     throws Exception
/*     */   {
/* 174 */     Enumeration enumer = props.propertyNames();
/* 175 */     while (enumer.hasMoreElements())
/*     */     {
/* 177 */       String roleKey = (String)enumer.nextElement();
/* 178 */       String comma_separated_roles = props.getProperty(roleKey);
/* 179 */       Principal pIdentity = createIdentity(roleKey);
/* 180 */       if (group.isMember(pIdentity))
/* 181 */         Util.parseGroupMembers(group, comma_separated_roles, this);
/* 182 */       if (this.REPLACE_ROLE)
/* 183 */         group.removeMember(pIdentity);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.RoleMappingLoginModule
 * JD-Core Version:    0.6.0
 */