/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.NamingEnumeration;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.directory.Attribute;
/*     */ import javax.naming.directory.Attributes;
/*     */ import javax.naming.directory.SearchControls;
/*     */ import javax.naming.directory.SearchResult;
/*     */ import javax.naming.ldap.InitialLdapContext;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SimpleGroup;
/*     */ 
/*     */ public class LdapLoginModule extends UsernamePasswordLoginModule
/*     */ {
/*     */   private static final String PRINCIPAL_DN_PREFIX_OPT = "principalDNPrefix";
/*     */   private static final String PRINCIPAL_DN_SUFFIX_OPT = "principalDNSuffix";
/*     */   private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
/*     */   private static final String USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT = "userRolesCtxDNAttributeName";
/*     */   private static final String UID_ATTRIBUTE_ID_OPT = "uidAttributeID";
/*     */   private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
/*     */   private static final String MATCH_ON_USER_DN_OPT = "matchOnUserDN";
/*     */   private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
/*     */   private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
/*     */   private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
/*     */   private static final String SEARCH_SCOPE_OPT = "searchScope";
/*     */   private static final String SECURITY_DOMAIN_OPT = "jaasSecurityDomain";
/* 184 */   private transient SimpleGroup userRoles = new SimpleGroup("Roles");
/*     */ 
/*     */   protected String getUsersPassword()
/*     */     throws LoginException
/*     */   {
/* 193 */     return "";
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets()
/*     */     throws LoginException
/*     */   {
/* 205 */     Group[] roleSets = { this.userRoles };
/* 206 */     return roleSets;
/*     */   }
/*     */ 
/*     */   protected boolean validatePassword(String inputPassword, String expectedPassword)
/*     */   {
/* 217 */     boolean isValid = false;
/* 218 */     if (inputPassword != null)
/*     */     {
/* 221 */       if (inputPassword.length() == 0)
/*     */       {
/* 224 */         boolean allowEmptyPasswords = true;
/* 225 */         String flag = (String)this.options.get("allowEmptyPasswords");
/* 226 */         if (flag != null)
/* 227 */           allowEmptyPasswords = Boolean.valueOf(flag).booleanValue();
/* 228 */         if (!allowEmptyPasswords)
/*     */         {
/* 230 */           this.log.trace("Rejecting empty password due to allowEmptyPasswords");
/* 231 */           return false;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 238 */         String username = getUsername();
/* 239 */         createLdapInitContext(username, inputPassword);
/* 240 */         isValid = true;
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 244 */         super.setValidateError(e);
/*     */       }
/*     */     }
/* 247 */     return isValid;
/*     */   }
/*     */ 
/*     */   private void createLdapInitContext(String username, Object credential)
/*     */     throws Exception
/*     */   {
/* 253 */     boolean trace = this.log.isTraceEnabled();
/* 254 */     Properties env = new Properties();
/*     */ 
/* 256 */     Iterator iter = this.options.entrySet().iterator();
/* 257 */     while (iter.hasNext())
/*     */     {
/* 259 */       Map.Entry entry = (Map.Entry)iter.next();
/* 260 */       env.put(entry.getKey(), entry.getValue());
/*     */     }
/*     */ 
/* 264 */     String factoryName = env.getProperty("java.naming.factory.initial");
/* 265 */     if (factoryName == null)
/*     */     {
/* 267 */       factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
/* 268 */       env.setProperty("java.naming.factory.initial", factoryName);
/*     */     }
/* 270 */     String authType = env.getProperty("java.naming.security.authentication");
/* 271 */     if (authType == null)
/* 272 */       env.setProperty("java.naming.security.authentication", "simple");
/* 273 */     String protocol = env.getProperty("java.naming.security.protocol");
/* 274 */     String providerURL = (String)this.options.get("java.naming.provider.url");
/* 275 */     if (providerURL == null) {
/* 276 */       providerURL = "ldap://localhost:" + ((protocol != null) && (protocol.equals("ssl")) ? "636" : "389");
/*     */     }
/* 278 */     String bindDN = (String)this.options.get("java.naming.security.principal");
/* 279 */     String bindCredential = (String)this.options.get("java.naming.security.credentials");
/* 280 */     String securityDomain = (String)this.options.get("jaasSecurityDomain");
/* 281 */     if (securityDomain != null)
/*     */     {
/* 283 */       ObjectName serviceName = new ObjectName(securityDomain);
/* 284 */       char[] tmp = DecodeAction.decode(bindCredential, serviceName);
/* 285 */       bindCredential = new String(tmp);
/*     */     }
/*     */ 
/* 288 */     String principalDNPrefix = (String)this.options.get("principalDNPrefix");
/* 289 */     if (principalDNPrefix == null)
/* 290 */       principalDNPrefix = "";
/* 291 */     String principalDNSuffix = (String)this.options.get("principalDNSuffix");
/* 292 */     if (principalDNSuffix == null)
/* 293 */       principalDNSuffix = "";
/* 294 */     String matchType = (String)this.options.get("matchOnUserDN");
/* 295 */     boolean matchOnUserDN = Boolean.valueOf(matchType).booleanValue();
/* 296 */     String userDN = principalDNPrefix + username + principalDNSuffix;
/* 297 */     env.setProperty("java.naming.provider.url", providerURL);
/* 298 */     env.setProperty("java.naming.security.principal", userDN);
/* 299 */     env.put("java.naming.security.credentials", credential);
/* 300 */     if (trace)
/*     */     {
/* 302 */       Properties tmp = new Properties();
/* 303 */       tmp.putAll(env);
/* 304 */       tmp.setProperty("java.naming.security.credentials", "***");
/* 305 */       this.log.trace("Logging into LDAP server, env=" + tmp.toString());
/*     */     }
/* 307 */     InitialLdapContext ctx = new InitialLdapContext(env, null);
/* 308 */     if (trace) {
/* 309 */       this.log.trace("Logged into LDAP server, " + ctx);
/*     */     }
/* 311 */     if (bindDN != null)
/*     */     {
/* 314 */       if (trace)
/* 315 */         this.log.trace("Rebind SECURITY_PRINCIPAL to: " + bindDN);
/* 316 */       env.setProperty("java.naming.security.principal", bindDN);
/* 317 */       env.put("java.naming.security.credentials", bindCredential);
/* 318 */       ctx = new InitialLdapContext(env, null);
/*     */     }
/*     */ 
/* 325 */     String rolesCtxDN = (String)this.options.get("rolesCtxDN");
/* 326 */     String userRolesCtxDNAttributeName = (String)this.options.get("userRolesCtxDNAttributeName");
/* 327 */     if (userRolesCtxDNAttributeName != null)
/*     */     {
/* 330 */       String[] returnAttribute = { userRolesCtxDNAttributeName };
/*     */       try
/*     */       {
/* 333 */         Attributes result = ctx.getAttributes(userDN, returnAttribute);
/* 334 */         if (result.get(userRolesCtxDNAttributeName) != null)
/*     */         {
/* 336 */           rolesCtxDN = result.get(userRolesCtxDNAttributeName).get().toString();
/* 337 */           this.log.trace("Found user roles context DN: " + rolesCtxDN);
/*     */         }
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 342 */         this.log.debug("Failed to query userRolesCtxDNAttributeName", e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 347 */     if (rolesCtxDN != null)
/*     */     {
/* 349 */       String uidAttrName = (String)this.options.get("uidAttributeID");
/* 350 */       if (uidAttrName == null)
/* 351 */         uidAttrName = "uid";
/* 352 */       String roleAttrName = (String)this.options.get("roleAttributeID");
/* 353 */       if (roleAttrName == null)
/* 354 */         roleAttrName = "roles";
/* 355 */       StringBuffer roleFilter = new StringBuffer("(");
/* 356 */       roleFilter.append(uidAttrName);
/* 357 */       roleFilter.append("={0})");
/* 358 */       String userToMatch = username;
/* 359 */       if (matchOnUserDN == true) {
/* 360 */         userToMatch = userDN;
/*     */       }
/* 362 */       String[] roleAttr = { roleAttrName };
/*     */ 
/* 364 */       String roleAttributeIsDNOption = (String)this.options.get("roleAttributeIsDN");
/* 365 */       boolean roleAttributeIsDN = Boolean.valueOf(roleAttributeIsDNOption).booleanValue();
/*     */ 
/* 369 */       String roleNameAttributeID = (String)this.options.get("roleNameAttributeID");
/* 370 */       if (roleNameAttributeID == null) {
/* 371 */         roleNameAttributeID = "name";
/*     */       }
/* 373 */       int searchScope = 2;
/* 374 */       int searchTimeLimit = 10000;
/* 375 */       String timeLimit = (String)this.options.get("searchTimeLimit");
/* 376 */       if (timeLimit != null)
/*     */       {
/*     */         try
/*     */         {
/* 380 */           searchTimeLimit = Integer.parseInt(timeLimit);
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/* 384 */           this.log.trace("Failed to parse: " + timeLimit + ", using searchTimeLimit=" + searchTimeLimit);
/*     */         }
/*     */       }
/* 387 */       String scope = (String)this.options.get("searchScope");
/* 388 */       if ("OBJECT_SCOPE".equalsIgnoreCase(scope))
/* 389 */         searchScope = 0;
/* 390 */       else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope))
/* 391 */         searchScope = 1;
/* 392 */       if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
/* 393 */         searchScope = 2;
/*     */       }
/*     */       try
/*     */       {
/* 397 */         SearchControls controls = new SearchControls();
/* 398 */         controls.setSearchScope(searchScope);
/* 399 */         controls.setReturningAttributes(roleAttr);
/* 400 */         controls.setTimeLimit(searchTimeLimit);
/* 401 */         Object[] filterArgs = { userToMatch };
/* 402 */         if (trace)
/*     */         {
/* 404 */           this.log.trace("searching rolesCtxDN=" + rolesCtxDN + ", roleFilter=" + roleFilter + ", filterArgs=" + userToMatch + ", roleAttr=" + roleAttr + ", searchScope=" + searchScope + ", searchTimeLimit=" + searchTimeLimit);
/*     */         }
/*     */ 
/* 409 */         NamingEnumeration answer = ctx.search(rolesCtxDN, roleFilter.toString(), filterArgs, controls);
/*     */ 
/* 411 */         while (answer.hasMore())
/*     */         {
/* 413 */           SearchResult sr = (SearchResult)answer.next();
/* 414 */           if (trace)
/*     */           {
/* 416 */             this.log.trace("Checking answer: " + sr.getName());
/*     */           }
/* 418 */           Attributes attrs = sr.getAttributes();
/* 419 */           Attribute roles = attrs.get(roleAttrName);
/* 420 */           for (int r = 0; r < roles.size(); r++)
/*     */           {
/* 422 */             Object value = roles.get(r);
/* 423 */             String roleName = null;
/* 424 */             if (roleAttributeIsDN == true)
/*     */             {
/* 427 */               String roleDN = value.toString();
/* 428 */               String[] returnAttribute = { roleNameAttributeID };
/* 429 */               if (trace)
/* 430 */                 this.log.trace("Following roleDN: " + roleDN);
/*     */               try
/*     */               {
/* 433 */                 Attributes result2 = ctx.getAttributes(roleDN, returnAttribute);
/* 434 */                 Attribute roles2 = result2.get(roleNameAttributeID);
/* 435 */                 if (roles2 != null)
/*     */                 {
/* 437 */                   for (int m = 0; m < roles2.size(); m++)
/*     */                   {
/* 439 */                     roleName = (String)roles2.get(m);
/* 440 */                     addRole(roleName);
/*     */                   }
/*     */                 }
/*     */               }
/*     */               catch (NamingException e)
/*     */               {
/* 446 */                 this.log.trace("Failed to query roleNameAttrName", e);
/*     */               }
/*     */ 
/*     */             }
/*     */             else
/*     */             {
/* 452 */               roleName = value.toString();
/* 453 */               addRole(roleName);
/*     */             }
/*     */           }
/*     */         }
/* 457 */         answer.close();
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 461 */         if (trace) {
/* 462 */           this.log.trace("Failed to locate roles", e);
/*     */         }
/*     */       }
/*     */     }
/* 466 */     ctx.close();
/*     */   }
/*     */ 
/*     */   private void addRole(String roleName)
/*     */   {
/* 471 */     if (roleName != null)
/*     */     {
/*     */       try
/*     */       {
/* 475 */         Principal p = super.createIdentity(roleName);
/* 476 */         this.log.trace("Assign user to role " + roleName);
/* 477 */         this.userRoles.addMember(p);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 481 */         this.log.debug("Failed to create principal: " + roleName, e);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.LdapLoginModule
 * JD-Core Version:    0.6.0
 */