/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.security.acl.Group;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.FailedLoginException;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import javax.sql.DataSource;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.plugins.TransactionManagerLocator;
/*     */ 
/*     */ public class DatabaseServerLoginModule extends UsernamePasswordLoginModule
/*     */ {
/*     */   protected String dsJndiName;
/*  76 */   protected String principalsQuery = "select Password from Principals where PrincipalID=?";
/*     */ 
/*  78 */   protected String rolesQuery = "select Role, RoleGroup from Roles where PrincipalID=?";
/*     */ 
/*  80 */   protected boolean suspendResume = true;
/*     */ 
/*  82 */   protected String TX_MGR_JNDI_NAME = "java:/TransactionManager";
/*     */ 
/*  84 */   protected TransactionManager tm = null;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*     */   {
/* 100 */     super.initialize(subject, callbackHandler, sharedState, options);
/* 101 */     this.dsJndiName = ((String)options.get("dsJndiName"));
/* 102 */     if (this.dsJndiName == null)
/* 103 */       this.dsJndiName = "java:/DefaultDS";
/* 104 */     Object tmp = options.get("principalsQuery");
/* 105 */     if (tmp != null)
/* 106 */       this.principalsQuery = tmp.toString();
/* 107 */     tmp = options.get("rolesQuery");
/* 108 */     if (tmp != null)
/* 109 */       this.rolesQuery = tmp.toString();
/* 110 */     tmp = options.get("suspendResume");
/* 111 */     if (tmp != null)
/* 112 */       this.suspendResume = Boolean.valueOf(tmp.toString()).booleanValue();
/* 113 */     if (this.log.isTraceEnabled())
/*     */     {
/* 115 */       this.log.trace("DatabaseServerLoginModule, dsJndiName=" + this.dsJndiName);
/* 116 */       this.log.trace("principalsQuery=" + this.principalsQuery);
/* 117 */       this.log.trace("rolesQuery=" + this.rolesQuery);
/* 118 */       this.log.trace("suspendResume=" + this.suspendResume);
/*     */     }
/*     */ 
/* 121 */     String jname = (String)options.get("transactionManagerJndiName");
/* 122 */     if (jname != null) {
/* 123 */       this.TX_MGR_JNDI_NAME = jname;
/*     */     }
/*     */     try
/*     */     {
/* 127 */       if (this.suspendResume)
/* 128 */         this.tm = getTransactionManager();
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 132 */       throw new RuntimeException("Unable to get Transaction Manager", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String getUsersPassword()
/*     */     throws LoginException
/*     */   {
/* 144 */     boolean trace = this.log.isTraceEnabled();
/* 145 */     String username = getUsername();
/* 146 */     String password = null;
/* 147 */     Connection conn = null;
/* 148 */     PreparedStatement ps = null;
/* 149 */     ResultSet rs = null;
/*     */ 
/* 151 */     Transaction tx = null;
/* 152 */     if (this.suspendResume)
/*     */     {
/*     */       try
/*     */       {
/* 157 */         if (this.tm == null)
/* 158 */           throw new IllegalStateException("Transaction Manager is null");
/* 159 */         tx = this.tm.suspend();
/*     */       }
/*     */       catch (SystemException e)
/*     */       {
/* 163 */         throw new RuntimeException(e);
/*     */       }
/* 165 */       if (trace) {
/* 166 */         this.log.trace("suspendAnyTransaction");
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 171 */       InitialContext ctx = new InitialContext();
/* 172 */       DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
/* 173 */       conn = ds.getConnection();
/*     */ 
/* 175 */       if (trace)
/* 176 */         this.log.trace("Excuting query: " + this.principalsQuery + ", with username: " + username);
/* 177 */       ps = conn.prepareStatement(this.principalsQuery);
/* 178 */       ps.setString(1, username);
/* 179 */       rs = ps.executeQuery();
/* 180 */       if (!rs.next())
/*     */       {
/* 182 */         if (trace)
/* 183 */           this.log.trace("Query returned no matches from db");
/* 184 */         throw new FailedLoginException("No matching username found in Principals");
/*     */       }
/*     */ 
/* 187 */       password = rs.getString(1);
/* 188 */       password = convertRawPassword(password);
/* 189 */       if (trace)
/* 190 */         this.log.trace("Obtained user password");
/*     */     }
/*     */     catch (NamingException ex)
/*     */     {
/* 194 */       LoginException le = new LoginException("Error looking up DataSource from: " + this.dsJndiName);
/* 195 */       le.initCause(ex);
/* 196 */       throw le;
/*     */     }
/*     */     catch (SQLException ex)
/*     */     {
/* 200 */       LoginException le = new LoginException("Query failed");
/* 201 */       le.initCause(ex);
/* 202 */       throw le;
/*     */     }
/*     */     finally
/*     */     {
/* 206 */       if (rs != null)
/*     */       {
/*     */         try
/*     */         {
/* 210 */           rs.close();
/*     */         }
/*     */         catch (SQLException e) {
/*     */         }
/*     */       }
/* 215 */       if (ps != null)
/*     */       {
/*     */         try
/*     */         {
/* 219 */           ps.close();
/*     */         }
/*     */         catch (SQLException e) {
/*     */         }
/*     */       }
/* 224 */       if (conn != null)
/*     */       {
/*     */         try
/*     */         {
/* 228 */           conn.close();
/*     */         }
/*     */         catch (SQLException ex) {
/*     */         }
/*     */       }
/* 233 */       if (this.suspendResume)
/*     */       {
/*     */         try
/*     */         {
/* 238 */           this.tm.resume(tx);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 242 */           throw new RuntimeException(e);
/*     */         }
/* 244 */         if (this.log.isTraceEnabled())
/* 245 */           this.log.trace("resumeAnyTransaction");
/*     */       }
/*     */     }
/* 248 */     return password;
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets()
/*     */     throws LoginException
/*     */   {
/* 258 */     String username = getUsername();
/* 259 */     if (this.log.isTraceEnabled())
/* 260 */       this.log.trace("getRoleSets using rolesQuery: " + this.rolesQuery + ", username: " + username);
/* 261 */     Group[] roleSets = Util.getRoleSets(username, this.dsJndiName, this.rolesQuery, this, this.suspendResume);
/*     */ 
/* 263 */     return roleSets;
/*     */   }
/*     */ 
/*     */   protected String convertRawPassword(String rawPassword)
/*     */   {
/* 274 */     return rawPassword;
/*     */   }
/*     */ 
/*     */   protected TransactionManager getTransactionManager() throws NamingException
/*     */   {
/* 279 */     TransactionManagerLocator tml = new TransactionManagerLocator();
/* 280 */     return tml.getTM(this.TX_MGR_JNDI_NAME);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.DatabaseServerLoginModule
 * JD-Core Version:    0.6.0
 */