/*    */ package org.jboss.security.auth.spi;
/*    */ 
/*    */ import java.security.acl.Group;
/*    */ import java.util.Map;
/*    */ import javax.security.auth.Subject;
/*    */ import javax.security.auth.callback.CallbackHandler;
/*    */ import javax.security.auth.login.LoginException;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class DatabaseCertLoginModule extends BaseCertLoginModule
/*    */ {
/*    */   private String dsJndiName;
/* 48 */   private String rolesQuery = "select Role, RoleGroup from Roles where PrincipalID=?";
/*    */ 
/* 50 */   protected boolean suspendResume = true;
/*    */ 
/*    */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*    */   {
/* 62 */     super.initialize(subject, callbackHandler, sharedState, options);
/* 63 */     this.dsJndiName = ((String)options.get("dsJndiName"));
/* 64 */     if (this.dsJndiName == null) {
/* 65 */       this.dsJndiName = "java:/DefaultDS";
/*    */     }
/* 67 */     Object tmp = options.get("rolesQuery");
/* 68 */     if (tmp != null) {
/* 69 */       this.rolesQuery = tmp.toString();
/*    */     }
/* 71 */     tmp = options.get("suspendResume");
/* 72 */     if (tmp != null) {
/* 73 */       this.suspendResume = Boolean.valueOf(tmp.toString()).booleanValue();
/*    */     }
/* 75 */     if (this.log.isTraceEnabled())
/*    */     {
/* 77 */       this.log.trace("DatabaseServerLoginModule, dsJndiName=" + this.dsJndiName);
/* 78 */       this.log.trace("rolesQuery=" + this.rolesQuery);
/* 79 */       this.log.trace("suspendResume=" + this.suspendResume);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected Group[] getRoleSets()
/*    */     throws LoginException
/*    */   {
/* 88 */     String username = getUsername();
/* 89 */     Group[] roleSets = Util.getRoleSets(username, this.dsJndiName, this.rolesQuery, this, this.suspendResume);
/* 90 */     return roleSets;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.DatabaseCertLoginModule
 * JD-Core Version:    0.6.0
 */