/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import javax.security.auth.spi.LoginModule;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.NestableGroup;
/*     */ import org.jboss.security.SimpleGroup;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public abstract class AbstractServerLoginModule
/*     */   implements LoginModule
/*     */ {
/*     */   protected Subject subject;
/*     */   protected CallbackHandler callbackHandler;
/*     */   protected Map sharedState;
/*     */   protected Map options;
/*     */   protected Logger log;
/*     */   protected boolean useFirstPass;
/*     */   protected boolean loginOk;
/*     */   protected String principalClassName;
/*     */   protected Principal unauthenticatedIdentity;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*     */   {
/* 116 */     this.subject = subject;
/* 117 */     this.callbackHandler = callbackHandler;
/* 118 */     this.sharedState = sharedState;
/* 119 */     this.options = options;
/* 120 */     this.log = Logger.getLogger(getClass());
/* 121 */     this.log.trace("initialize");
/*     */ 
/* 124 */     this.log.trace("Security domain: " + (String)options.get("jboss.security.security_domain"));
/*     */ 
/* 131 */     String passwordStacking = (String)options.get("password-stacking");
/* 132 */     if ((passwordStacking != null) && (passwordStacking.equalsIgnoreCase("useFirstPass"))) {
/* 133 */       this.useFirstPass = true;
/*     */     }
/*     */ 
/* 136 */     this.principalClassName = ((String)options.get("principalClass"));
/*     */ 
/* 139 */     String name = (String)options.get("unauthenticatedIdentity");
/* 140 */     if (name != null)
/*     */     {
/*     */       try
/*     */       {
/* 144 */         this.unauthenticatedIdentity = createIdentity(name);
/* 145 */         this.log.trace("Saw unauthenticatedIdentity=" + name);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 149 */         this.log.warn("Failed to create custom unauthenticatedIdentity", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/* 165 */     this.log.trace("login");
/* 166 */     this.loginOk = false;
/*     */ 
/* 168 */     if (this.useFirstPass == true)
/*     */     {
/*     */       try
/*     */       {
/* 172 */         Object identity = this.sharedState.get("javax.security.auth.login.name");
/* 173 */         Object credential = this.sharedState.get("javax.security.auth.login.password");
/* 174 */         if ((identity != null) && (credential != null))
/*     */         {
/* 176 */           this.loginOk = true;
/* 177 */           return true;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 183 */         this.log.error("login failed", e);
/*     */       }
/*     */     }
/* 186 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean commit()
/*     */     throws LoginException
/*     */   {
/* 201 */     this.log.trace("commit, loginOk=" + this.loginOk);
/* 202 */     if (!this.loginOk) {
/* 203 */       return false;
/*     */     }
/* 205 */     Set principals = this.subject.getPrincipals();
/* 206 */     Principal identity = getIdentity();
/* 207 */     principals.add(identity);
/* 208 */     Group[] roleSets = getRoleSets();
/* 209 */     for (int g = 0; g < roleSets.length; g++)
/*     */     {
/* 211 */       Group group = roleSets[g];
/* 212 */       String name = group.getName();
/* 213 */       Group subjectGroup = createGroup(name, principals);
/* 214 */       if ((subjectGroup instanceof NestableGroup))
/*     */       {
/* 219 */         SimpleGroup tmp = new SimpleGroup("Roles");
/* 220 */         subjectGroup.addMember(tmp);
/* 221 */         subjectGroup = tmp;
/*     */       }
/*     */ 
/* 224 */       Enumeration members = group.members();
/* 225 */       while (members.hasMoreElements())
/*     */       {
/* 227 */         Principal role = (Principal)members.nextElement();
/* 228 */         subjectGroup.addMember(role);
/*     */       }
/*     */     }
/* 231 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean abort()
/*     */     throws LoginException
/*     */   {
/* 239 */     this.log.trace("abort");
/* 240 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean logout()
/*     */     throws LoginException
/*     */   {
/* 248 */     this.log.trace("logout");
/*     */ 
/* 250 */     Principal identity = getIdentity();
/* 251 */     Set principals = this.subject.getPrincipals();
/* 252 */     principals.remove(identity);
/*     */ 
/* 254 */     return true;
/*     */   }
/*     */ 
/*     */   protected abstract Principal getIdentity();
/*     */ 
/*     */   protected abstract Group[] getRoleSets()
/*     */     throws LoginException;
/*     */ 
/*     */   protected boolean getUseFirstPass()
/*     */   {
/* 275 */     return this.useFirstPass;
/*     */   }
/*     */ 
/*     */   protected Principal getUnauthenticatedIdentity() {
/* 279 */     return this.unauthenticatedIdentity;
/*     */   }
/*     */ 
/*     */   protected Group createGroup(String name, Set principals)
/*     */   {
/* 288 */     Group roles = null;
/* 289 */     Iterator iter = principals.iterator();
/* 290 */     while (iter.hasNext())
/*     */     {
/* 292 */       Object next = iter.next();
/* 293 */       if (!(next instanceof Group))
/*     */         continue;
/* 295 */       Group grp = (Group)next;
/* 296 */       if (grp.getName().equals(name))
/*     */       {
/* 298 */         roles = grp;
/* 299 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 303 */     if (roles == null)
/*     */     {
/* 305 */       roles = new SimpleGroup(name);
/* 306 */       principals.add(roles);
/*     */     }
/* 308 */     return roles;
/*     */   }
/*     */ 
/*     */   protected Principal createIdentity(String username)
/*     */     throws Exception
/*     */   {
/* 323 */     Principal p = null;
/* 324 */     if (this.principalClassName == null)
/*     */     {
/* 326 */       p = new SimplePrincipal(username);
/*     */     }
/*     */     else
/*     */     {
/* 330 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 331 */       Class clazz = loader.loadClass(this.principalClassName);
/* 332 */       Class[] ctorSig = { String.class };
/* 333 */       Constructor ctor = clazz.getConstructor(ctorSig);
/* 334 */       Object[] ctorArgs = { username };
/* 335 */       p = (Principal)ctor.newInstance(ctorArgs);
/*     */     }
/* 337 */     return p;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.AbstractServerLoginModule
 * JD-Core Version:    0.6.0
 */