/*     */ package org.jboss.security.auth.message.config;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.message.AuthException;
/*     */ import javax.security.auth.message.MessageInfo;
/*     */ import javax.security.auth.message.config.ServerAuthConfig;
/*     */ import javax.security.auth.message.config.ServerAuthContext;
/*     */ import javax.security.auth.message.module.ServerAuthModule;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.auth.callback.SecurityAssociationHandler;
/*     */ import org.jboss.security.auth.container.config.AuthModuleEntry;
/*     */ import org.jboss.security.auth.container.modules.DelegatingServerAuthModule;
/*     */ import org.jboss.security.auth.login.AuthenticationInfo;
/*     */ import org.jboss.security.auth.login.BaseAuthenticationInfo;
/*     */ import org.jboss.security.auth.login.JASPIAuthenticationInfo;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.security.config.SecurityConfiguration;
/*     */ 
/*     */ public class JBossServerAuthConfig
/*     */   implements ServerAuthConfig
/*     */ {
/*     */   private String layer;
/*     */   private String contextId;
/*     */   private CallbackHandler callbackHandler;
/*  63 */   private List modules = new ArrayList();
/*     */   private Map contextProperties;
/*     */ 
/*     */   public JBossServerAuthConfig(String layer, String appContext, CallbackHandler handler, Map properties)
/*     */   {
/*  77 */     this.layer = layer;
/*  78 */     this.contextId = appContext;
/*  79 */     this.callbackHandler = handler;
/*  80 */     this.contextProperties = properties;
/*     */   }
/*     */ 
/*     */   public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties)
/*     */     throws AuthException
/*     */   {
/*  90 */     Map mapOptionsByName = new HashMap();
/*  91 */     SecurityContext securityContext = SecurityActions.getSecurityContext();
/*  92 */     if (securityContext == null)
/*  93 */       throw new IllegalStateException("Security Context is null");
/*  94 */     String secDomain = securityContext.getSecurityDomain();
/*     */ 
/*  96 */     String defaultAppDomain = "other";
/*     */ 
/*  98 */     ApplicationPolicy ap = SecurityConfiguration.getApplicationPolicy(secDomain);
/*  99 */     if (ap == null)
/*     */     {
/* 101 */       ap = SecurityConfiguration.getApplicationPolicy(defaultAppDomain);
/*     */     }
/* 103 */     if (ap == null)
/* 104 */       throw new IllegalStateException("No Application Policy found");
/* 105 */     BaseAuthenticationInfo bai = ap.getAuthenticationInfo();
/* 106 */     if (bai == null) {
/* 107 */       throw new IllegalStateException("Authentication Info not set in security domain=" + secDomain + " or " + defaultAppDomain);
/*     */     }
/*     */ 
/* 110 */     if ((bai instanceof AuthenticationInfo))
/*     */     {
/* 113 */       ServerAuthModule sam = new DelegatingServerAuthModule();
/* 114 */       Map options = new HashMap();
/* 115 */       options.put("javax.security.auth.login.LoginContext", secDomain);
/* 116 */       sam.initialize(null, null, new SecurityAssociationHandler(), options);
/* 117 */       this.modules.add(sam);
/*     */     }
/*     */     else
/*     */     {
/* 121 */       JASPIAuthenticationInfo jai = (JASPIAuthenticationInfo)bai;
/* 122 */       AuthModuleEntry[] amearr = jai.getAuthModuleEntry();
/* 123 */       for (AuthModuleEntry ame : amearr)
/*     */       {
/* 125 */         if (ame.getLoginModuleStackHolderName() != null)
/*     */         {
/*     */           try
/*     */           {
/* 129 */             mapOptionsByName.put(ame.getAuthModuleName(), ame.getOptions());
/*     */ 
/* 131 */             this.modules.add(createSAM(ame.getAuthModuleName(), ame.getLoginModuleStackHolderName()));
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 136 */             throw new AuthException(e.getLocalizedMessage());
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/*     */           try
/*     */           {
/* 143 */             mapOptionsByName.put(ame.getAuthModuleName(), ame.getOptions());
/* 144 */             this.modules.add(createSAM(ame.getAuthModuleName()));
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 148 */             throw new AuthException(e.getLocalizedMessage());
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 154 */     return new JBossServerAuthContext(this.modules, mapOptionsByName, this.callbackHandler);
/*     */   }
/*     */ 
/*     */   public String getAppContext()
/*     */   {
/* 162 */     return this.contextId;
/*     */   }
/*     */ 
/*     */   public String getMessageLayer()
/*     */   {
/* 170 */     return this.layer;
/*     */   }
/*     */ 
/*     */   public void refresh()
/*     */     throws AuthException, SecurityException
/*     */   {
/*     */   }
/*     */ 
/*     */   public List getServerAuthModules()
/*     */   {
/* 184 */     return this.modules;
/*     */   }
/*     */ 
/*     */   public String getAuthContextID(MessageInfo messageInfo)
/*     */   {
/* 189 */     return this.contextId;
/*     */   }
/*     */ 
/*     */   public boolean isProtected()
/*     */   {
/* 194 */     throw new RuntimeException("Not Implemented");
/*     */   }
/*     */ 
/*     */   private ServerAuthModule createSAM(String name)
/*     */     throws Exception
/*     */   {
/* 200 */     Class clazz = SecurityActions.getContextClassloader().loadClass(name);
/* 201 */     Constructor ctr = clazz.getConstructor(new Class[0]);
/* 202 */     return (ServerAuthModule)ctr.newInstance(new Object[0]);
/*     */   }
/*     */ 
/*     */   private ServerAuthModule createSAM(String name, String lmshName)
/*     */     throws Exception
/*     */   {
/* 208 */     Class clazz = SecurityActions.getContextClassloader().loadClass(name);
/* 209 */     Constructor ctr = clazz.getConstructor(new Class[] { String.class });
/* 210 */     return (ServerAuthModule)ctr.newInstance(new Object[] { lmshName });
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.message.config.JBossServerAuthConfig
 * JD-Core Version:    0.6.0
 */