/*     */ package org.jboss.security.auth.message.config;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.message.AuthException;
/*     */ import javax.security.auth.message.AuthStatus;
/*     */ import javax.security.auth.message.MessageInfo;
/*     */ import javax.security.auth.message.config.ClientAuthContext;
/*     */ import javax.security.auth.message.module.ClientAuthModule;
/*     */ 
/*     */ public class JBossClientAuthContext
/*     */   implements ClientAuthContext
/*     */ {
/*     */   private JBossClientAuthConfig config;
/*     */ 
/*     */   public JBossClientAuthContext(JBossClientAuthConfig config)
/*     */   {
/*  53 */     if (config == null)
/*  54 */       throw new IllegalArgumentException("config is null");
/*  55 */     this.config = config;
/*     */   }
/*     */ 
/*     */   public void cleanSubject(MessageInfo messageInfo, Subject subject)
/*     */     throws AuthException
/*     */   {
/*  64 */     AuthStatus status = null;
/*  65 */     Iterator iter = this.config.getClientAuthModules().iterator();
/*  66 */     while (iter.hasNext())
/*     */     {
/*  68 */       ((ClientAuthModule)iter.next()).cleanSubject(messageInfo, subject);
/*     */     }
/*     */   }
/*     */ 
/*     */   public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject)
/*     */     throws AuthException
/*     */   {
/*  77 */     Iterator iter = this.config.getClientAuthModules().iterator();
/*  78 */     AuthStatus status = null;
/*  79 */     while (iter.hasNext())
/*     */     {
/*  81 */       status = ((ClientAuthModule)iter.next()).secureRequest(messageInfo, clientSubject);
/*  82 */       if (status == AuthStatus.FAILURE)
/*  83 */         break;
/*     */     }
/*  85 */     return status;
/*     */   }
/*     */ 
/*     */   public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject)
/*     */     throws AuthException
/*     */   {
/*  94 */     Iterator iter = this.config.getClientAuthModules().iterator();
/*  95 */     AuthStatus status = null;
/*  96 */     while (iter.hasNext())
/*     */     {
/*  98 */       status = ((ClientAuthModule)iter.next()).validateResponse(messageInfo, clientSubject, serviceSubject);
/*     */ 
/* 100 */       if (status == AuthStatus.FAILURE)
/* 101 */         break;
/*     */     }
/* 103 */     return status;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.message.config.JBossClientAuthContext
 * JD-Core Version:    0.6.0
 */