/*     */ package org.jboss.security.auth.message.config;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.UUID;
/*     */ import javax.security.auth.message.AuthException;
/*     */ import javax.security.auth.message.config.AuthConfigFactory.RegistrationContext;
/*     */ import javax.security.auth.message.config.AuthConfigProvider;
/*     */ import javax.security.auth.message.config.RegistrationListener;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class AuthProviderRegistrationDelegate
/*     */ {
/*  50 */   private static Logger log = Logger.getLogger(AuthProviderRegistrationDelegate.class);
/*     */ 
/*  57 */   private Map keyProviderMap = new HashMap();
/*     */ 
/*  62 */   private Map keyListenerMap = new HashMap();
/*     */ 
/*  67 */   private Map idToDescriptionMap = new HashMap();
/*     */ 
/*  72 */   private Map idKeyMap = new HashMap();
/*     */ 
/*  77 */   private Map providerToIDListMap = new HashMap();
/*     */ 
/*     */   public String[] detachListener(RegistrationListener listener, String layer, String appContext)
/*     */   {
/*  90 */     if (listener == null)
/*  91 */       throw new IllegalArgumentException("listener is null");
/*  92 */     String[] arr = new String[0];
/*  93 */     String input = (layer + "_" + appContext).toUpperCase();
/*  94 */     String allLayer = ("NULL_" + appContext).toUpperCase();
/*  95 */     String allContext = (layer + "_" + "NULL").toUpperCase();
/*  96 */     String general = "NULL_NULL";
/*     */ 
/*  98 */     RegistrationListener origListener = null;
/*  99 */     String key = null;
/* 100 */     for (int i = 0; (i < 4) && (origListener == null); i++)
/*     */     {
/* 102 */       if (i == 0) key = input;
/* 103 */       if (i == 1) key = allLayer;
/* 104 */       if (i == 2) key = allContext;
/* 105 */       if (i == 3) key = general;
/* 106 */       origListener = (RegistrationListener)this.keyListenerMap.get(key);
/*     */     }
/*     */ 
/* 109 */     if (origListener == listener)
/*     */     {
/* 111 */       this.keyListenerMap.remove(key);
/*     */ 
/* 113 */       AuthConfigProvider provider = (AuthConfigProvider)this.keyProviderMap.get(key);
/* 114 */       if (provider != null)
/*     */       {
/* 116 */         List list = (List)this.providerToIDListMap.get(provider);
/* 117 */         arr = new String[list.size()];
/* 118 */         list.toArray(arr);
/*     */       }
/*     */     }
/* 121 */     return arr;
/*     */   }
/*     */ 
/*     */   public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener)
/*     */   {
/* 130 */     if (appContext == null)
/* 131 */       appContext = " ";
/* 132 */     String input = (layer + "_" + appContext).toUpperCase();
/* 133 */     String allLayer = ("NULL_" + appContext).toUpperCase();
/* 134 */     String allContext = (layer + "_" + "NULL").toUpperCase();
/* 135 */     String general = "NULL_NULL";
/*     */ 
/* 137 */     AuthConfigProvider acp = null;
/* 138 */     String key = null;
/* 139 */     for (int i = 0; (i < 4) && (acp == null); i++)
/*     */     {
/* 141 */       if (i == 0) key = input;
/* 142 */       if (i == 1) key = allLayer;
/* 143 */       if (i == 2) key = allContext;
/* 144 */       if (i == 3) key = general;
/* 145 */       acp = (AuthConfigProvider)this.keyProviderMap.get(key);
/*     */     }
/* 147 */     if ((acp != null) && (listener != null)) {
/* 148 */       this.keyListenerMap.put(key, listener);
/*     */     }
/* 150 */     return acp;
/*     */   }
/*     */ 
/*     */   public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID)
/*     */   {
/* 158 */     String description = (String)this.idToDescriptionMap.get(registrationID);
/* 159 */     String key = (String)this.idKeyMap.get(registrationID);
/* 160 */     StringTokenizer st = new StringTokenizer(key, "_");
/* 161 */     if (st.countTokens() < 2)
/* 162 */       throw new IllegalStateException("Invalid key obtained=" + key);
/* 163 */     String layer = st.nextToken();
/* 164 */     String appCtx = st.nextToken();
/*     */ 
/* 166 */     return new AuthConfigFactory.RegistrationContext(appCtx, description, layer)
/*     */     {
/*     */       public String getAppContext()
/*     */       {
/* 170 */         return this.val$appCtx.equals("NULL") ? null : this.val$appCtx;
/*     */       }
/*     */ 
/*     */       public String getDescription()
/*     */       {
/* 175 */         return this.val$description;
/*     */       }
/*     */ 
/*     */       public String getMessageLayer()
/*     */       {
/* 180 */         return this.val$layer.equals("NULL") ? null : this.val$layer;
/*     */       }
/*     */ 
/*     */       public boolean isPersistent()
/*     */       {
/* 185 */         return false;
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public String[] getRegistrationIDs(AuthConfigProvider provider)
/*     */   {
/* 195 */     List al = new ArrayList();
/* 196 */     if (provider == null)
/*     */     {
/* 198 */       al.addAll(this.idToDescriptionMap.keySet());
/*     */     }
/*     */     else
/*     */     {
/* 202 */       List list = (List)this.providerToIDListMap.get(provider);
/* 203 */       if (list != null)
/* 204 */         al.addAll(list);
/*     */     }
/* 206 */     String[] sarr = new String[al.size()];
/* 207 */     al.toArray(sarr);
/* 208 */     return sarr;
/*     */   }
/*     */ 
/*     */   public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description)
/*     */     throws AuthException, SecurityException
/*     */   {
/* 218 */     if ((className == null) || (className.length() == 0)) {
/* 219 */       throw new IllegalArgumentException("className is null or zero length");
/*     */     }
/*     */ 
/* 222 */     AuthConfigProvider acp = null;
/*     */     try
/*     */     {
/* 225 */       Class provClass = Thread.currentThread().getContextClassLoader().loadClass(className);
/* 226 */       Constructor ctr = provClass.getConstructor(new Class[] { Map.class });
/* 227 */       acp = (AuthConfigProvider)ctr.newInstance(new Object[] { properties });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 231 */       log.error("Cannot register provider:" + className + ":", e);
/* 232 */       throw new AuthException("Cannot register Provider " + className + ":reason=" + e);
/*     */     }
/*     */ 
/* 235 */     return registerConfigProvider(acp, layer, appContext, description);
/*     */   }
/*     */ 
/*     */   public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description)
/*     */   {
/* 241 */     if (provider == null) {
/* 242 */       throw new IllegalArgumentException("provider is null");
/*     */     }
/* 244 */     StringBuilder key = new StringBuilder();
/* 245 */     key.append(layer == null ? "NULL" : layer.toUpperCase());
/* 246 */     key.append("_");
/* 247 */     key.append(appContext == null ? "NULL" : appContext.toUpperCase());
/*     */ 
/* 249 */     String keystr = key.toString();
/* 250 */     this.keyProviderMap.put(keystr, provider);
/*     */ 
/* 253 */     UUID guid = UUID.randomUUID();
/* 254 */     String providerID = guid.toString();
/* 255 */     this.idKeyMap.put(providerID, keystr);
/* 256 */     List list = (List)this.providerToIDListMap.get(provider);
/* 257 */     if (list == null)
/*     */     {
/* 259 */       list = new ArrayList();
/*     */     }
/* 261 */     list.add(providerID);
/* 262 */     this.providerToIDListMap.put(provider, list);
/* 263 */     if (description != null) {
/* 264 */       this.idToDescriptionMap.put(providerID, description);
/*     */     }
/*     */ 
/* 267 */     RegistrationListener listener = (RegistrationListener)this.keyListenerMap.get(keystr);
/* 268 */     if (listener != null) {
/* 269 */       listener.notify(layer, appContext);
/*     */     }
/* 271 */     return providerID;
/*     */   }
/*     */ 
/*     */   public boolean removeRegistration(String registrationID)
/*     */   {
/* 279 */     if (registrationID == null) {
/* 280 */       throw new IllegalArgumentException("registrationID is null");
/*     */     }
/* 282 */     String key = (String)this.idKeyMap.get(registrationID);
/* 283 */     if (key != null)
/*     */     {
/* 285 */       RegistrationListener listener = (RegistrationListener)this.keyListenerMap.get(key);
/* 286 */       AuthConfigFactory.RegistrationContext rc = getRegistrationContext(registrationID);
/*     */ 
/* 288 */       this.keyProviderMap.remove(key);
/*     */ 
/* 290 */       if (listener != null)
/* 291 */         listener.notify(rc.getMessageLayer(), rc.getAppContext());
/* 292 */       return true;
/*     */     }
/* 294 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.message.config.AuthProviderRegistrationDelegate
 * JD-Core Version:    0.6.0
 */