/*     */ package org.jboss.security.auth.login;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ import javax.security.auth.login.Configuration;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class XMLLoginConfig extends ServiceMBeanSupport
/*     */   implements XMLLoginConfigMBean
/*     */ {
/*     */   XMLLoginConfigImpl config;
/*     */ 
/*     */   public XMLLoginConfig()
/*     */   {
/*  48 */     this.config = new XMLLoginConfigImpl();
/*     */   }
/*     */ 
/*     */   public URL getConfigURL()
/*     */   {
/*  58 */     return this.config.getConfigURL();
/*     */   }
/*     */ 
/*     */   public void setConfigURL(URL configURL)
/*     */   {
/*  65 */     this.config.setConfigURL(configURL);
/*     */   }
/*     */ 
/*     */   public void setConfigResource(String resourceName)
/*     */     throws IOException
/*     */   {
/*  74 */     this.config.setConfigResource(resourceName);
/*     */   }
/*     */ 
/*     */   public boolean getValidateDTD()
/*     */   {
/*  81 */     return this.config.getValidateDTD();
/*     */   }
/*     */ 
/*     */   public void setValidateDTD(boolean flag)
/*     */   {
/*  87 */     this.config.setValidateDTD(flag);
/*     */   }
/*     */ 
/*     */   public void addApplicationPolicy(String appName, ApplicationPolicy aPolicy)
/*     */   {
/*  95 */     this.config.addApplicationPolicy(appName, aPolicy);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void addAppConfig(String appName, AppConfigurationEntry[] entries)
/*     */   {
/* 104 */     this.config.addAppConfig(appName, entries);
/*     */   }
/*     */ 
/*     */   public void removeAppConfig(String appName)
/*     */   {
/* 111 */     this.config.removeAppConfig(appName);
/*     */   }
/*     */ 
/*     */   public ApplicationPolicy getApplicationPolicy(String domainName)
/*     */   {
/* 119 */     return this.config.getApplicationPolicy(domainName);
/*     */   }
/*     */ 
/*     */   public Configuration getConfiguration(Configuration prevConfig)
/*     */   {
/* 127 */     this.config.setParentConfig(prevConfig);
/* 128 */     return this.config;
/*     */   }
/*     */ 
/*     */   public String[] loadConfig(URL configURL)
/*     */     throws Exception
/*     */   {
/* 137 */     return this.config.loadConfig(configURL);
/*     */   }
/*     */ 
/*     */   public void removeConfigs(String[] appNames)
/*     */   {
/* 142 */     int count = appNames == null ? 0 : appNames.length;
/* 143 */     for (int a = 0; a < count; a++)
/* 144 */       removeAppConfig(appNames[a]);
/*     */   }
/*     */ 
/*     */   public String displayAppConfig(String appName)
/*     */   {
/* 151 */     StringBuffer buffer = new StringBuffer("<h2>" + appName + " LoginConfiguration</h2>\n");
/* 152 */     AppConfigurationEntry[] appEntry = this.config.getAppConfigurationEntry(appName);
/* 153 */     if (appEntry == null) {
/* 154 */       buffer.append("No Entry\n");
/*     */     }
/*     */     else {
/* 157 */       for (int c = 0; c < appEntry.length; c++)
/*     */       {
/* 159 */         AppConfigurationEntry entry = appEntry[c];
/* 160 */         buffer.append("LoginModule Class: " + entry.getLoginModuleName());
/* 161 */         buffer.append("\n<br>ControlFlag: " + entry.getControlFlag());
/* 162 */         buffer.append("\n<br>Options:<ul>");
/* 163 */         Map options = entry.getOptions();
/* 164 */         Iterator iter = options.entrySet().iterator();
/* 165 */         while (iter.hasNext())
/*     */         {
/* 167 */           Map.Entry e = (Map.Entry)iter.next();
/* 168 */           buffer.append("<li>");
/* 169 */           buffer.append("name=" + e.getKey());
/* 170 */           buffer.append(", value=" + e.getValue());
/* 171 */           buffer.append("</li>\n");
/*     */         }
/* 173 */         buffer.append("</ul>\n");
/*     */       }
/*     */     }
/* 176 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 186 */     this.config.loadConfig();
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */   {
/* 193 */     this.config.clear();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.XMLLoginConfig
 * JD-Core Version:    0.6.0
 */