/*     */ package org.jboss.security.auth.login;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.io.Reader;
/*     */ import java.io.StringReader;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Vector;
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ import javax.security.auth.login.AppConfigurationEntry.LoginModuleControlFlag;
/*     */ 
/*     */ public class SunConfigParser
/*     */   implements SunConfigParserConstants
/*     */ {
/*     */   private XMLLoginConfigImpl loginConfig;
/*     */   public SunConfigParserTokenManager token_source;
/*     */   SimpleCharStream jj_input_stream;
/*     */   public Token token;
/*     */   public Token jj_nt;
/*     */   private int jj_ntk;
/*     */   private int jj_gen;
/* 260 */   private final int[] jj_la1 = new int[6];
/*     */   private static int[] jj_la1_0;
/* 367 */   private Vector jj_expentries = new Vector();
/*     */   private int[] jj_expentry;
/* 369 */   private int jj_kind = -1;
/*     */ 
/* 404 */   private int trace_indent = 0;
/* 405 */   private boolean trace_enabled = true;
/*     */ 
/*     */   public SunConfigParser()
/*     */   {
/*  32 */     this(new StringReader(""));
/*     */   }
/*     */ 
/*     */   public void parse(Reader configFile, XMLLoginConfigImpl loginConfig)
/*     */     throws ParseException
/*     */   {
/*  38 */     parse(configFile, loginConfig, false);
/*     */   }
/*     */ 
/*     */   public void parse(Reader configFile, XMLLoginConfigImpl loginConfig, boolean trace)
/*     */     throws ParseException
/*     */   {
/*  44 */     ReInit(configFile);
/*     */ 
/*  47 */     if (trace)
/*     */     {
/*  49 */       enable_tracing();
/*     */     }
/*     */     else
/*     */     {
/*  53 */       disable_tracing();
/*     */     }
/*     */ 
/*  56 */     this.loginConfig = loginConfig;
/*  57 */     config();
/*     */   }
/*     */ 
/*     */   private String stripQuotes(String image)
/*     */   {
/*  66 */     return image.substring(1, image.length() - 1);
/*     */   }
/*     */ 
/*     */   public static void doParse(Reader configFile, XMLLoginConfigImpl loginConfig)
/*     */     throws ParseException
/*     */   {
/*  72 */     doParse(configFile, loginConfig, false);
/*     */   }
/*     */ 
/*     */   public static void doParse(Reader configFile, XMLLoginConfigImpl loginConfig, boolean trace)
/*     */     throws ParseException
/*     */   {
/*  78 */     SunConfigParser parser = new SunConfigParser();
/*  79 */     parser.parse(configFile, loginConfig, trace);
/*     */   }
/*     */ 
/*     */   public final void config() throws ParseException
/*     */   {
/*  84 */     trace_call("config");
/*     */     try
/*     */     {
/*     */       while (true) {
/*  88 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*     */         {
/*     */         case 16:
/*  91 */           break;
/*     */         default:
/*  93 */           this.jj_la1[0] = this.jj_gen;
/*  94 */           break;
/*     */         }
/*  96 */         appConfig();
/*     */       }
/*  98 */       jj_consume_token(0);
/*     */     } finally {
/* 100 */       trace_return("config");
/*     */     }
/*     */   }
/*     */ 
/*     */   public final void appConfig() throws ParseException {
/* 105 */     trace_call("appConfig");
/*     */     try {
/* 107 */       Token t = null;
/*     */ 
/* 110 */       ArrayList entries = new ArrayList();
/* 111 */       t = jj_consume_token(16);
/* 112 */       String appName = t.image;
/* 113 */       jj_consume_token(7);
/*     */       while (true)
/*     */       {
/* 116 */         AppConfigurationEntry entry = loginModuleConfig();
/* 117 */         entries.add(entry);
/* 118 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*     */         {
/*     */         case 17:
/*     */         }
/*     */       }
/* 123 */       this.jj_la1[1] = this.jj_gen;
/*     */ 
/* 127 */       jj_consume_token(8);
/* 128 */       jj_consume_token(9);
/* 129 */       AppConfigurationEntry[] appConfig = new AppConfigurationEntry[entries.size()];
/* 130 */       entries.toArray(appConfig);
/* 131 */       this.loginConfig.addAppConfig(appName, appConfig);
/*     */     } finally {
/* 133 */       trace_return("appConfig");
/*     */     }
/*     */   }
/*     */ 
/*     */   public final AppConfigurationEntry loginModuleConfig() throws ParseException {
/* 138 */     trace_call("loginModuleConfig");
/*     */     try {
/* 140 */       Token t = null;
/*     */ 
/* 142 */       HashMap optionsMap = new HashMap();
/*     */ 
/* 145 */       t = jj_consume_token(17);
/* 146 */       String loginModuleClassName = t.image;
/* 147 */       AppConfigurationEntry.LoginModuleControlFlag controlFlag = controlFlag();
/*     */       while (true)
/*     */       {
/* 150 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk)
/*     */         {
/*     */         case 16:
/*     */         case 17:
/* 154 */           break;
/*     */         default:
/* 156 */           this.jj_la1[2] = this.jj_gen;
/* 157 */           break;
/*     */         }
/* 159 */         moduleOptions(optionsMap);
/*     */       }
/* 161 */       jj_consume_token(9);
/* 162 */       AppConfigurationEntry entry = new AppConfigurationEntry(loginModuleClassName, controlFlag, optionsMap);
/* 163 */       AppConfigurationEntry localAppConfigurationEntry1 = entry;
/*     */       return localAppConfigurationEntry1; } finally { trace_return("loginModuleConfig"); } throw localObject;
/*     */   }
/*     */ 
/*     */   public final AppConfigurationEntry.LoginModuleControlFlag controlFlag() throws ParseException
/*     */   {
/* 171 */     trace_call("controlFlag");
/*     */     try
/*     */     {
/* 174 */       AppConfigurationEntry.LoginModuleControlFlag flag = null;
/* 175 */       Token t = jj_consume_token(15);
/* 176 */       if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(t.image) > 0)
/* 177 */         flag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
/* 178 */       else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(t.image) > 0)
/* 179 */         flag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
/* 180 */       else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(t.image) > 0)
/* 181 */         flag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
/* 182 */       else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(t.image) > 0)
/* 183 */         flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
/* 184 */       AppConfigurationEntry.LoginModuleControlFlag localLoginModuleControlFlag1 = flag;
/*     */       return localLoginModuleControlFlag1; } finally { trace_return("controlFlag"); } throw localObject;
/*     */   }
/*     */ 
/*     */   public final void moduleOptions(HashMap optionsMap) throws ParseException
/*     */   {
/* 192 */     trace_call("moduleOptions");
/*     */     try
/*     */     {
/*     */       Token t;
/* 196 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*     */       case 16:
/* 198 */         t = jj_consume_token(16);
/* 199 */         break;
/*     */       case 17:
/* 201 */         t = jj_consume_token(17);
/* 202 */         break;
/*     */       default:
/* 204 */         this.jj_la1[3] = this.jj_gen;
/* 205 */         jj_consume_token(-1);
/* 206 */         throw new ParseException();
/*     */       }
/* 208 */       String name = t.image;
/* 209 */       jj_consume_token(10);
/*     */       String value;
/* 210 */       switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*     */       case 11:
/*     */       case 12:
/*     */       case 16:
/*     */       case 17:
/*     */       case 20:
/* 216 */         switch (this.jj_ntk == -1 ? jj_ntk() : this.jj_ntk) {
/*     */         case 16:
/* 218 */           t = jj_consume_token(16);
/* 219 */           break;
/*     */         case 17:
/* 221 */           t = jj_consume_token(17);
/* 222 */           break;
/*     */         case 12:
/* 224 */           t = jj_consume_token(12);
/* 225 */           break;
/*     */         case 11:
/* 227 */           t = jj_consume_token(11);
/* 228 */           break;
/*     */         case 20:
/* 230 */           t = jj_consume_token(20);
/* 231 */           break;
/*     */         case 13:
/*     */         case 14:
/*     */         case 15:
/*     */         case 18:
/*     */         case 19:
/*     */         default:
/* 233 */           this.jj_la1[4] = this.jj_gen;
/* 234 */           jj_consume_token(-1);
/* 235 */           throw new ParseException();
/*     */         }
/* 237 */         value = t.image;
/* 238 */         optionsMap.put(name, value);
/* 239 */         break;
/*     */       case 14:
/* 241 */         t = jj_consume_token(14);
/* 242 */         value = stripQuotes(t.image);
/* 243 */         optionsMap.put(name, value);
/* 244 */         break;
/*     */       case 13:
/*     */       case 15:
/*     */       case 18:
/*     */       case 19:
/*     */       default:
/* 246 */         this.jj_la1[5] = this.jj_gen;
/* 247 */         jj_consume_token(-1);
/* 248 */         throw new ParseException();
/*     */       }
/*     */     } finally {
/* 251 */       trace_return("moduleOptions");
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void jj_la1_0()
/*     */   {
/* 266 */     jj_la1_0 = new int[] { 65536, 131072, 196608, 196608, 1251328, 1267712 };
/*     */   }
/*     */ 
/*     */   public SunConfigParser(InputStream stream) {
/* 270 */     this(stream, null);
/*     */   }
/*     */   public SunConfigParser(InputStream stream, String encoding) {
/*     */     try { this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch (UnsupportedEncodingException e) { throw new RuntimeException(e); }
/* 274 */     this.token_source = new SunConfigParserTokenManager(this.jj_input_stream);
/* 275 */     this.token = new Token();
/* 276 */     this.jj_ntk = -1;
/* 277 */     this.jj_gen = 0;
/* 278 */     for (int i = 0; i < 6; i++) this.jj_la1[i] = -1; 
/*     */   }
/*     */ 
/*     */   public void ReInit(InputStream stream)
/*     */   {
/* 282 */     ReInit(stream, null);
/*     */   }
/*     */   public void ReInit(InputStream stream, String encoding) {
/*     */     try { this.jj_input_stream.ReInit(stream, encoding, 1, 1); } catch (UnsupportedEncodingException e) { throw new RuntimeException(e); }
/* 286 */     this.token_source.ReInit(this.jj_input_stream);
/* 287 */     this.token = new Token();
/* 288 */     this.jj_ntk = -1;
/* 289 */     this.jj_gen = 0;
/* 290 */     for (int i = 0; i < 6; i++) this.jj_la1[i] = -1; 
/*     */   }
/*     */ 
/*     */   public SunConfigParser(Reader stream)
/*     */   {
/* 294 */     this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
/* 295 */     this.token_source = new SunConfigParserTokenManager(this.jj_input_stream);
/* 296 */     this.token = new Token();
/* 297 */     this.jj_ntk = -1;
/* 298 */     this.jj_gen = 0;
/* 299 */     for (int i = 0; i < 6; i++) this.jj_la1[i] = -1; 
/*     */   }
/*     */ 
/*     */   public void ReInit(Reader stream)
/*     */   {
/* 303 */     this.jj_input_stream.ReInit(stream, 1, 1);
/* 304 */     this.token_source.ReInit(this.jj_input_stream);
/* 305 */     this.token = new Token();
/* 306 */     this.jj_ntk = -1;
/* 307 */     this.jj_gen = 0;
/* 308 */     for (int i = 0; i < 6; i++) this.jj_la1[i] = -1; 
/*     */   }
/*     */ 
/*     */   public SunConfigParser(SunConfigParserTokenManager tm)
/*     */   {
/* 312 */     this.token_source = tm;
/* 313 */     this.token = new Token();
/* 314 */     this.jj_ntk = -1;
/* 315 */     this.jj_gen = 0;
/* 316 */     for (int i = 0; i < 6; i++) this.jj_la1[i] = -1; 
/*     */   }
/*     */ 
/*     */   public void ReInit(SunConfigParserTokenManager tm)
/*     */   {
/* 320 */     this.token_source = tm;
/* 321 */     this.token = new Token();
/* 322 */     this.jj_ntk = -1;
/* 323 */     this.jj_gen = 0;
/* 324 */     for (int i = 0; i < 6; i++) this.jj_la1[i] = -1;
/*     */   }
/*     */ 
/*     */   private final Token jj_consume_token(int kind)
/*     */     throws ParseException
/*     */   {
/* 329 */     Token oldToken;
/* 329 */     if ((oldToken = this.token).next != null) this.token = this.token.next; else
/* 330 */       this.token = (this.token.next = this.token_source.getNextToken());
/* 331 */     this.jj_ntk = -1;
/* 332 */     if (this.token.kind == kind) {
/* 333 */       this.jj_gen += 1;
/* 334 */       trace_token(this.token, "");
/* 335 */       return this.token;
/*     */     }
/* 337 */     this.token = oldToken;
/* 338 */     this.jj_kind = kind;
/* 339 */     throw generateParseException();
/*     */   }
/*     */ 
/*     */   public final Token getNextToken() {
/* 343 */     if (this.token.next != null) this.token = this.token.next; else
/* 344 */       this.token = (this.token.next = this.token_source.getNextToken());
/* 345 */     this.jj_ntk = -1;
/* 346 */     this.jj_gen += 1;
/* 347 */     trace_token(this.token, " (in getNextToken)");
/* 348 */     return this.token;
/*     */   }
/*     */ 
/*     */   public final Token getToken(int index) {
/* 352 */     Token t = this.token;
/* 353 */     for (int i = 0; i < index; i++) {
/* 354 */       if (t.next != null) t = t.next; else
/* 355 */         t = t.next = this.token_source.getNextToken();
/*     */     }
/* 357 */     return t;
/*     */   }
/*     */ 
/*     */   private final int jj_ntk() {
/* 361 */     if ((this.jj_nt = this.token.next) == null) {
/* 362 */       return this.jj_ntk = (this.token.next = this.token_source.getNextToken()).kind;
/*     */     }
/* 364 */     return this.jj_ntk = this.jj_nt.kind;
/*     */   }
/*     */ 
/*     */   public ParseException generateParseException()
/*     */   {
/* 372 */     this.jj_expentries.removeAllElements();
/* 373 */     boolean[] la1tokens = new boolean[22];
/* 374 */     for (int i = 0; i < 22; i++) {
/* 375 */       la1tokens[i] = false;
/*     */     }
/* 377 */     if (this.jj_kind >= 0) {
/* 378 */       la1tokens[this.jj_kind] = true;
/* 379 */       this.jj_kind = -1;
/*     */     }
/* 381 */     for (int i = 0; i < 6; i++) {
/* 382 */       if (this.jj_la1[i] == this.jj_gen) {
/* 383 */         for (int j = 0; j < 32; j++) {
/* 384 */           if ((jj_la1_0[i] & 1 << j) != 0) {
/* 385 */             la1tokens[j] = true;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 390 */     for (int i = 0; i < 22; i++) {
/* 391 */       if (la1tokens[i] != 0) {
/* 392 */         this.jj_expentry = new int[1];
/* 393 */         this.jj_expentry[0] = i;
/* 394 */         this.jj_expentries.addElement(this.jj_expentry);
/*     */       }
/*     */     }
/* 397 */     int[][] exptokseq = new int[this.jj_expentries.size()][];
/* 398 */     for (int i = 0; i < this.jj_expentries.size(); i++) {
/* 399 */       exptokseq[i] = ((int[])(int[])this.jj_expentries.elementAt(i));
/*     */     }
/* 401 */     return new ParseException(this.token, exptokseq, tokenImage);
/*     */   }
/*     */ 
/*     */   public final void enable_tracing()
/*     */   {
/* 408 */     this.trace_enabled = true;
/*     */   }
/*     */ 
/*     */   public final void disable_tracing() {
/* 412 */     this.trace_enabled = false;
/*     */   }
/*     */ 
/*     */   private final void trace_call(String s) {
/* 416 */     if (this.trace_enabled) {
/* 417 */       for (int i = 0; i < this.trace_indent; i++) System.out.print(" ");
/* 418 */       System.out.println("Call:   " + s);
/*     */     }
/* 420 */     this.trace_indent += 2;
/*     */   }
/*     */ 
/*     */   private final void trace_return(String s) {
/* 424 */     this.trace_indent -= 2;
/* 425 */     if (this.trace_enabled) {
/* 426 */       for (int i = 0; i < this.trace_indent; i++) System.out.print(" ");
/* 427 */       System.out.println("Return: " + s);
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void trace_token(Token t, String where) {
/* 432 */     if (this.trace_enabled) {
/* 433 */       for (int i = 0; i < this.trace_indent; i++) System.out.print(" ");
/* 434 */       System.out.print("Consumed token: <" + tokenImage[t.kind]);
/* 435 */       if ((t.kind != 0) && (!tokenImage[t.kind].equals("\"" + t.image + "\""))) {
/* 436 */         System.out.print(": \"" + t.image + "\"");
/*     */       }
/* 438 */       System.out.println(" at line " + t.beginLine + " column " + t.beginColumn + ">" + where);
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void trace_scan(Token t1, int t2) {
/* 443 */     if (this.trace_enabled) {
/* 444 */       for (int i = 0; i < this.trace_indent; i++) System.out.print(" ");
/* 445 */       System.out.print("Visited token: <" + tokenImage[t1.kind]);
/* 446 */       if ((t1.kind != 0) && (!tokenImage[t1.kind].equals("\"" + t1.image + "\""))) {
/* 447 */         System.out.print(": \"" + t1.image + "\"");
/*     */       }
/* 449 */       System.out.println(" at line " + t1.beginLine + " column " + t1.beginColumn + ">; Expected token: <" + tokenImage[t2] + ">");
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 263 */     jj_la1_0();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.SunConfigParser
 * JD-Core Version:    0.6.0
 */