/*    */ package org.jboss.security.auth.login;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import javax.security.auth.AuthPermission;
/*    */ import javax.security.auth.login.AppConfigurationEntry;
/*    */ 
/*    */ public class LoginModuleStackHolder
/*    */ {
/* 39 */   public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
/* 40 */   public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
/*    */ 
/* 42 */   private String name = "";
/*    */   private ArrayList appEntries;
/*    */ 
/*    */   public LoginModuleStackHolder(String name, List entries)
/*    */   {
/* 48 */     this.name = name;
/* 49 */     if (entries != null)
/*    */     {
/* 51 */       this.appEntries = new ArrayList();
/* 52 */       this.appEntries.addAll(entries);
/*    */     }
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 58 */     return this.name;
/*    */   }
/*    */ 
/*    */   public void addAppConfigurationEntry(AppConfigurationEntry entry)
/*    */   {
/* 63 */     if (this.appEntries == null)
/* 64 */       this.appEntries = new ArrayList();
/* 65 */     this.appEntries.add(entry);
/*    */   }
/*    */ 
/*    */   public AppConfigurationEntry[] getAppConfigurationEntry()
/*    */   {
/* 70 */     SecurityManager sm = System.getSecurityManager();
/* 71 */     if (sm != null)
/* 72 */       sm.checkPermission(GET_CONFIG_ENTRY_PERM);
/* 73 */     AppConfigurationEntry[] entries = new AppConfigurationEntry[this.appEntries.size()];
/* 74 */     this.appEntries.toArray(entries);
/* 75 */     return entries;
/*    */   }
/*    */ 
/*    */   public void setAppConfigurationEntry(List entries)
/*    */   {
/* 80 */     if (entries == null)
/* 81 */       throw new IllegalArgumentException("Illegal Null Argument: entries");
/* 82 */     if (this.appEntries == null)
/* 83 */       this.appEntries = new ArrayList();
/* 84 */     this.appEntries.addAll(entries);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.LoginModuleStackHolder
 * JD-Core Version:    0.6.0
 */