/*     */ package org.jboss.security.auth.login;
/*     */ 
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.auth.container.config.AuthModuleEntry;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.security.config.PolicyConfig;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class LoginConfigObjectModelFactory
/*     */   implements ObjectModelFactory
/*     */ {
/*  43 */   private static Logger log = Logger.getLogger(LoginConfigObjectModelFactory.class);
/*     */   private boolean trace;
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*     */   {
/*  49 */     if (this.trace)
/*  50 */       log.trace("completeRoot");
/*  51 */     return root;
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  57 */     this.trace = log.isTraceEnabled();
/*  58 */     if (!localName.equals("policy"))
/*     */     {
/*  60 */       throw new IllegalStateException("Unexpected root element: was expecting 'policy' but got '" + localName + "'");
/*     */     }
/*  62 */     if (this.trace)
/*  63 */       log.trace("newRoot, created PolicyConfig for policy element");
/*  64 */     return new PolicyConfig();
/*     */   }
/*     */ 
/*     */   public Object newChild(PolicyConfig config, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/*  71 */     Object child = null;
/*  72 */     if (this.trace)
/*  73 */       log.trace("newChild.PolicyConfig, localName: " + localName);
/*  74 */     if ("application-policy".equals(localName))
/*     */     {
/*  76 */       String name = attrs.getValue("name");
/*  77 */       name = StringPropertyReplacer.replaceProperties(name);
/*  78 */       ApplicationPolicy aPolicy = new ApplicationPolicy(name);
/*  79 */       aPolicy.setPolicyConfig(config);
/*  80 */       String baseAppPolicyName = attrs.getValue("extends");
/*  81 */       if (baseAppPolicyName != null)
/*  82 */         aPolicy.setBaseApplicationPolicyName(baseAppPolicyName);
/*  83 */       if (this.trace)
/*  84 */         log.trace("newChild.PolicyConfig, AuthenticationInfo: " + name);
/*  85 */       child = aPolicy;
/*     */     }
/*  87 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(ApplicationPolicy aPolicy, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/*  93 */     Object child = null;
/*  94 */     if (this.trace)
/*  95 */       log.trace("newChild.ApplicationPolicy, localName: " + localName);
/*  96 */     String name = aPolicy.getName();
/*  97 */     if ("authentication".equals(localName))
/*     */     {
/*  99 */       child = new AuthenticationInfo(name);
/* 100 */       if (this.trace)
/* 101 */         log.trace("newChild.PolicyConfig, AuthenticationInfo: " + name);
/*     */     }
/* 103 */     else if ("authentication-jaspi".equals(localName))
/*     */     {
/* 105 */       child = new JASPIAuthenticationInfo(name);
/* 106 */       if (this.trace)
/* 107 */         log.trace("newChild.PolicyConfig, AuthenticationInfo: " + name);
/*     */     }
/* 109 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(BaseAuthenticationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 115 */     Object child = null;
/* 116 */     if (this.trace)
/* 117 */       log.trace("newChild.AuthenticationInfo, localName: " + localName);
/* 118 */     if ("authentication".equals(localName))
/*     */     {
/* 120 */       child = new AuthenticationInfo(info.getName());
/* 121 */       if (this.trace)
/* 122 */         log.trace("newChild.PolicyConfig, AuthenticationInfo: " + info.getName());
/*     */     }
/* 124 */     else if ("authentication-jaspi".equals(localName))
/*     */     {
/* 126 */       child = new JASPIAuthenticationInfo(info.getName());
/* 127 */       if (this.trace)
/* 128 */         log.trace("newChild.PolicyConfig, AuthenticationInfo: " + info.getName());
/*     */     }
/* 130 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(AuthenticationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 136 */     Object child = null;
/* 137 */     if (this.trace)
/* 138 */       log.trace("newChild.AuthenticationInfo, localName: " + localName);
/* 139 */     if ("login-module".equals(localName))
/*     */     {
/* 141 */       String code = attrs.getValue("code");
/* 142 */       code = StringPropertyReplacer.replaceProperties(code.trim());
/* 143 */       String flag = attrs.getValue("flag");
/* 144 */       if (flag != null)
/* 145 */         flag = StringPropertyReplacer.replaceProperties(flag.trim());
/* 146 */       AppConfigurationEntryHolder holder = new AppConfigurationEntryHolder(code, flag);
/* 147 */       child = holder;
/* 148 */       if (this.trace) {
/* 149 */         log.trace("newChild.AuthenticationInfo, login-module code: " + code);
/*     */       }
/*     */     }
/* 152 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(JASPIAuthenticationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 158 */     Object child = null;
/* 159 */     if (this.trace)
/* 160 */       log.trace("newChild.AuthenticationJaspiInfo, localName: " + localName);
/* 161 */     if ("login-module-stack".equals(localName))
/*     */     {
/* 163 */       String lmsName = attrs.getValue("name");
/* 164 */       lmsName = StringPropertyReplacer.replaceProperties(lmsName.trim());
/* 165 */       child = new LoginModuleStackHolder(lmsName, null);
/* 166 */       if (this.trace)
/* 167 */         log.trace("newChild.AuthenticationInfo, login-module-stack: " + lmsName);
/*     */     }
/* 169 */     else if ("auth-module".equals(localName))
/*     */     {
/* 171 */       String code = attrs.getValue("code");
/* 172 */       child = new AuthModuleEntry(code, null, null);
/* 173 */       String lmsRef = attrs.getValue("login-module-stack-ref");
/* 174 */       if (lmsRef != null) {
/* 175 */         ((AuthModuleEntry)child).setLoginModuleStackHolder(info.getLoginModuleStackHolder(lmsRef));
/*     */       }
/*     */     }
/* 178 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(LoginModuleStackHolder entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 184 */     Object child = null;
/* 185 */     if (this.trace)
/* 186 */       log.trace("newChild.LoginModuleStackHolder, localName: " + localName);
/* 187 */     if ("login-module".equals(localName))
/*     */     {
/* 189 */       String code = attrs.getValue("code");
/* 190 */       code = StringPropertyReplacer.replaceProperties(code.trim());
/* 191 */       String flag = attrs.getValue("flag");
/* 192 */       flag = StringPropertyReplacer.replaceProperties(flag.trim());
/* 193 */       AppConfigurationEntryHolder holder = new AppConfigurationEntryHolder(code, flag);
/* 194 */       child = holder;
/* 195 */       if (this.trace) {
/* 196 */         log.trace("newChild.AuthenticationInfo, login-module code: " + code);
/*     */       }
/*     */     }
/* 199 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(AppConfigurationEntryHolder entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 206 */     Object child = null;
/* 207 */     if (this.trace)
/* 208 */       log.trace("newChild.AppConfigurationEntryHolder, localName: " + localName);
/* 209 */     if ("module-option".equals(localName))
/*     */     {
/* 211 */       String name = attrs.getValue("name");
/* 212 */       child = new ModuleOption(name);
/* 213 */       if (this.trace) {
/* 214 */         log.trace("newChild.AppConfigurationEntryHolder, module-option name: " + name);
/*     */       }
/*     */     }
/* 217 */     return child;
/*     */   }
/*     */ 
/*     */   public Object newChild(AuthModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs)
/*     */   {
/* 223 */     Object child = null;
/* 224 */     if (this.trace)
/* 225 */       log.trace("newChild.AppConfigurationEntryHolder, localName: " + localName);
/* 226 */     if ("module-option".equals(localName))
/*     */     {
/* 228 */       String name = attrs.getValue("name");
/* 229 */       child = new ModuleOption(name);
/* 230 */       if (this.trace) {
/* 231 */         log.trace("newChild.AuthModuleEntry, module-option name: " + name);
/*     */       }
/*     */     }
/* 234 */     return child;
/*     */   }
/*     */ 
/*     */   public void setValue(ModuleOption option, UnmarshallingContext navigator, String namespaceUri, String localName, String value)
/*     */   {
/* 240 */     if ("module-option".equals(localName))
/*     */     {
/* 242 */       String valueWithReplacement = StringPropertyReplacer.replaceProperties(value.trim());
/* 243 */       option.setValue(valueWithReplacement);
/* 244 */       if (this.trace)
/* 245 */         log.trace("setValue.ModuleOption, name: " + localName + ":valueWithReplacement:" + valueWithReplacement);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addChild(ModuleOption option, Object value, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 253 */     option.setValue(value);
/* 254 */     if (this.trace)
/* 255 */       log.trace("addChild.ModuleOption, name: " + option.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(AuthenticationInfo authInfo, AppConfigurationEntryHolder entryInfo, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 261 */     AppConfigurationEntry entry = entryInfo.getEntry();
/* 262 */     authInfo.addAppConfigurationEntry(entry);
/* 263 */     if (this.trace)
/* 264 */       log.trace("addChild.AuthenticationInfo, name: " + entry.getLoginModuleName());
/*     */   }
/*     */ 
/*     */   public void addChild(AppConfigurationEntryHolder entryInfo, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 270 */     entryInfo.addOption(option);
/* 271 */     if (this.trace)
/* 272 */       log.trace("addChild.AppConfigurationEntryHolder, name: " + option.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(JASPIAuthenticationInfo authInfo, AuthModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 278 */     authInfo.add(entry);
/*     */   }
/*     */ 
/*     */   public void addChild(LoginModuleStackHolder lmsh, AppConfigurationEntryHolder entryInfo, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 284 */     lmsh.addAppConfigurationEntry(entryInfo.getEntry());
/* 285 */     if (this.trace)
/* 286 */       log.trace("addChild.LoginModuleStackHolder, name: " + entryInfo.getEntry().getLoginModuleName());
/*     */   }
/*     */ 
/*     */   public void addChild(AuthModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 292 */     entry.addOption(option);
/* 293 */     if (this.trace)
/* 294 */       log.trace("addChild.AppConfigurationEntryHolder, name: " + option.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(JASPIAuthenticationInfo authInfo, LoginModuleStackHolder lmsHolder, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 300 */     authInfo.add(lmsHolder);
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationPolicy aPolicy, JASPIAuthenticationInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 306 */     aPolicy.setAuthenticationInfo(authInfo);
/* 307 */     if (this.trace)
/* 308 */       log.trace("addChild.ApplicationPolicy, name: " + aPolicy.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(ApplicationPolicy aPolicy, AuthenticationInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 314 */     aPolicy.setAuthenticationInfo(authInfo);
/* 315 */     if (this.trace)
/* 316 */       log.trace("addChild.ApplicationPolicy, name: " + aPolicy.getName());
/*     */   }
/*     */ 
/*     */   public void addChild(PolicyConfig pc, ApplicationPolicy aPolicy, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 322 */     pc.add(aPolicy);
/* 323 */     if (this.trace)
/* 324 */       log.trace("Added ApplicationPolicy to PolicyConfig, name: " + aPolicy.getName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.LoginConfigObjectModelFactory
 * JD-Core Version:    0.6.0
 */