/*     */ package org.jboss.security.auth.login;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxy;
/*     */ import org.jboss.security.config.ApplicationPolicy;
/*     */ import org.jboss.security.config.PolicyConfig;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfigImplMBean;
/*     */ 
/*     */ public class DynamicLoginConfig extends ServiceMBeanSupport
/*     */   implements DynamicLoginConfigMBean
/*     */ {
/*  72 */   private String authConf = "login-config.xml";
/*     */   private ObjectName loginConfigService;
/*     */   private ObjectName securityMgrService;
/*     */   private String[] configNames;
/*     */   private PolicyConfig config;
/*     */ 
/*     */   public String getName()
/*     */   {
/*  87 */     return "Dynamic JAAS Login Config";
/*     */   }
/*     */ 
/*     */   public PolicyConfig getPolicyConfig()
/*     */   {
/*  92 */     return this.config;
/*     */   }
/*     */ 
/*     */   public void setPolicyConfig(PolicyConfig config) {
/*  96 */     this.config = config;
/*     */   }
/*     */ 
/*     */   public ObjectName getLoginConfigService()
/*     */   {
/* 101 */     return this.loginConfigService;
/*     */   }
/*     */ 
/*     */   public void setLoginConfigService(ObjectName serviceName)
/*     */   {
/* 110 */     this.loginConfigService = serviceName;
/*     */   }
/*     */ 
/*     */   public ObjectName getSecurityManagerService()
/*     */   {
/* 115 */     return this.securityMgrService;
/*     */   }
/*     */ 
/*     */   public void setSecurityManagerService(ObjectName serviceName)
/*     */   {
/* 126 */     this.securityMgrService = serviceName;
/*     */   }
/*     */ 
/*     */   public String getAuthConfig()
/*     */   {
/* 133 */     return this.authConf;
/*     */   }
/*     */ 
/*     */   public void setAuthConfig(String authConf)
/*     */   {
/* 141 */     this.authConf = authConf;
/*     */   }
/*     */ 
/*     */   public void flushAuthenticationCaches()
/*     */     throws Exception
/*     */   {
/* 151 */     if ((this.securityMgrService != null) && (this.server.isRegistered(this.securityMgrService)))
/*     */     {
/* 153 */       int count = this.configNames == null ? 0 : this.configNames.length;
/* 154 */       String[] sig = { String.class.getName() };
/* 155 */       for (int n = 0; n < count; n++)
/*     */       {
/* 157 */         Object[] args = { this.configNames[n] };
/* 158 */         this.server.invoke(this.securityMgrService, "flushAuthenticationCache", args, sig);
/* 159 */         this.log.debug("Flushed domain: " + this.configNames[n]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 169 */     if (this.config != null)
/*     */     {
/* 171 */       this.log.debug("Using embedded config");
/* 172 */       Set names = this.config.getConfigNames();
/* 173 */       Iterator iter = names.iterator();
/* 174 */       MBeanServer server = super.getServer();
/* 175 */       while (iter.hasNext())
/*     */       {
/* 177 */         String name = (String)iter.next();
/* 178 */         ApplicationPolicy aPolicy = this.config.get(name);
/* 179 */         if (aPolicy == null) {
/* 180 */           throw new IllegalStateException("Application Policy is null for " + name);
/*     */         }
/* 182 */         AuthenticationInfo info = (AuthenticationInfo)aPolicy.getAuthenticationInfo();
/* 183 */         if (info == null)
/* 184 */           throw new IllegalStateException("Authentication Info is null for " + name);
/* 185 */         AppConfigurationEntry[] entry = info.getAppConfigurationEntry();
/*     */ 
/* 189 */         Object[] args = { name, aPolicy };
/* 190 */         String[] sig = { String.class.getName(), aPolicy.getClass().getName() };
/*     */ 
/* 192 */         server.invoke(this.loginConfigService, "addApplicationPolicy", args, sig);
/*     */       }
/* 194 */       this.configNames = new String[names.size()];
/* 195 */       names.toArray(this.configNames);
/*     */     }
/*     */     else
/*     */     {
/* 200 */       if ((this.authConf == null) || (this.authConf.length() == 0)) {
/* 201 */         throw new IllegalStateException("AuthConf is null. Please configure an appropriate config resource");
/*     */       }
/*     */ 
/* 205 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 206 */       URL loginConfig = loader.getResource(this.authConf);
/* 207 */       if (loginConfig == null)
/*     */       {
/*     */         try
/*     */         {
/* 212 */           loginConfig = new URL(this.authConf);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 216 */           loginConfig = null;
/*     */         }
/*     */       }
/* 219 */       if (loginConfig != null)
/*     */       {
/* 221 */         validateAuthConfigURL(loginConfig.toExternalForm());
/* 222 */         this.log.debug("Using JAAS AuthConfig: " + loginConfig.toExternalForm());
/* 223 */         MBeanServer server = super.getServer();
/* 224 */         Object[] args = { loginConfig };
/* 225 */         String[] sig = { URL.class.getName() };
/* 226 */         this.configNames = ((String[])(String[])server.invoke(this.loginConfigService, "loadConfig", args, sig));
/*     */ 
/* 228 */         int count = this.configNames == null ? 0 : this.configNames.length;
/* 229 */         for (int n = 0; n < count; n++)
/*     */         {
/* 231 */           this.log.debug("Loaded config: " + this.configNames[n]);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 236 */         throw new DeploymentException("Failed to find authConf as resource: " + this.authConf);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 246 */     MBeanServer server = super.getServer();
/* 247 */     flushAuthenticationCaches();
/* 248 */     if ((this.configNames != null) && (this.configNames.length > 0))
/*     */     {
/* 250 */       Object[] args = { this.configNames };
/* 251 */       String[] sig = { this.configNames.getClass().getName() };
/* 252 */       server.invoke(this.loginConfigService, "removeConfigs", args, sig);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void validateAuthConfigURL(String url)
/*     */     throws Exception
/*     */   {
/* 264 */     String msg = "AuthConfig is defaulting to conf/login-config.xml. Please check your archive.";
/*     */ 
/* 266 */     ServerConfigImplMBean mb = null;
/*     */     try
/*     */     {
/* 269 */       mb = (ServerConfigImplMBean)MBeanProxy.get(ServerConfigImplMBean.class, ServerConfigImplMBean.OBJECT_NAME, this.server);
/*     */ 
/* 271 */       URL serverConfigURL = mb.getServerConfigURL();
/* 272 */       if (url.equalsIgnoreCase(serverConfigURL.toExternalForm() + "login-config.xml")) {
/* 273 */         throw new IllegalStateException(msg);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 278 */       mb = null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.DynamicLoginConfig
 * JD-Core Version:    0.6.0
 */