/*     */ package org.jboss.security.auth.login;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ import javax.security.auth.login.AppConfigurationEntry.LoginModuleControlFlag;
/*     */ import org.jboss.util.xml.DOMUtils;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class ConfigUtil
/*     */ {
/*     */   public static AuthenticationInfo parseAuthentication(Element policy)
/*     */     throws Exception
/*     */   {
/*  49 */     NodeList authentication = policy.getElementsByTagName("authentication");
/*  50 */     if (authentication.getLength() == 0)
/*     */     {
/*  52 */       return null;
/*     */     }
/*     */ 
/*  55 */     Element auth = (Element)authentication.item(0);
/*  56 */     NodeList modules = auth.getElementsByTagName("login-module");
/*  57 */     ArrayList tmp = new ArrayList();
/*  58 */     for (int n = 0; n < modules.getLength(); n++)
/*     */     {
/*  60 */       Element module = (Element)modules.item(n);
/*  61 */       parseModule(module, tmp);
/*     */     }
/*  63 */     AppConfigurationEntry[] entries = new AppConfigurationEntry[tmp.size()];
/*  64 */     tmp.toArray(entries);
/*  65 */     AuthenticationInfo info = new AuthenticationInfo();
/*  66 */     info.setAppConfigurationEntry(entries);
/*  67 */     return info;
/*     */   }
/*     */ 
/*     */   static void parseModule(Element module, ArrayList entries)
/*     */     throws Exception
/*     */   {
/*  73 */     AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
/*  74 */     String className = DOMUtils.getAttributeValue(module, "code");
/*  75 */     String flag = DOMUtils.getAttributeValue(module, "flag");
/*  76 */     if (flag != null)
/*     */     {
/*  79 */       flag = flag.toLowerCase();
/*  80 */       if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(flag) > 0)
/*  81 */         controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
/*  82 */       else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(flag) > 0)
/*  83 */         controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
/*  84 */       else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(flag) > 0)
/*  85 */         controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
/*  86 */       else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(flag) > 0)
/*  87 */         controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
/*     */     }
/*  89 */     NodeList opts = module.getElementsByTagName("module-option");
/*  90 */     HashMap options = new HashMap();
/*  91 */     for (int n = 0; n < opts.getLength(); n++)
/*     */     {
/*  93 */       Element opt = (Element)opts.item(n);
/*  94 */       String name = opt.getAttribute("name");
/*  95 */       String value = DOMUtils.getTextContent(opt);
/*  96 */       if (value == null)
/*  97 */         value = "";
/*  98 */       options.put(name, value);
/*     */     }
/* 100 */     AppConfigurationEntry entry = new AppConfigurationEntry(className, controlFlag, options);
/* 101 */     entries.add(entry);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.ConfigUtil
 * JD-Core Version:    0.6.0
 */