/*     */ package org.jboss.security.auth.login;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.auth.container.config.AuthModuleEntry;
/*     */ import org.jboss.xb.binding.GenericValueContainer;
/*     */ 
/*     */ public class AuthenticationInfoContainer
/*     */   implements GenericValueContainer
/*     */ {
/*  46 */   private static Logger log = Logger.getLogger(AuthenticationInfoContainer.class);
/*     */ 
/*  48 */   BaseAuthenticationInfo info = null;
/*     */ 
/*  50 */   String authName = null;
/*     */ 
/*  52 */   List moduleEntries = new ArrayList();
/*     */ 
/*  54 */   Map loginModuleStackMap = new HashMap();
/*     */ 
/*  56 */   boolean isJASPIAuthentication = false;
/*     */ 
/*     */   public void addChild(QName name, Object value)
/*     */   {
/*  60 */     log.debug("addChild::" + name + ":" + value);
/*  61 */     if ("name".equals(name.getLocalPart()))
/*     */     {
/*  63 */       this.authName = ((String)value);
/*     */     }
/*  65 */     else if ((value instanceof AppConfigurationEntryHolder))
/*     */     {
/*  67 */       AppConfigurationEntryHolder ace = (AppConfigurationEntryHolder)value;
/*  68 */       this.moduleEntries.add(ace.getEntry());
/*     */     }
/*  70 */     else if ((value instanceof AppConfigurationEntry))
/*     */     {
/*  72 */       AppConfigurationEntry ace = (AppConfigurationEntry)value;
/*  73 */       this.moduleEntries.add(ace);
/*     */     }
/*  75 */     else if ((value instanceof AuthModuleEntry))
/*     */     {
/*  77 */       AuthModuleEntry ame = (AuthModuleEntry)value;
/*     */ 
/*  79 */       String lmshName = ame.getLoginModuleStackHolderName();
/*  80 */       if (lmshName != null)
/*  81 */         ame.setLoginModuleStackHolder((LoginModuleStackHolder)this.loginModuleStackMap.get(lmshName));
/*  82 */       this.moduleEntries.add(ame);
/*  83 */       this.isJASPIAuthentication = true;
/*     */     }
/*  85 */     else if ((value instanceof LoginModuleStackHolder))
/*     */     {
/*  87 */       LoginModuleStackHolder lmsh = (LoginModuleStackHolder)value;
/*  88 */       this.loginModuleStackMap.put(lmsh.getName(), lmsh);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object instantiate()
/*     */   {
/*  94 */     if (!this.isJASPIAuthentication)
/*     */     {
/*  96 */       this.info = new AuthenticationInfo(this.authName);
/*     */     }
/*     */     else
/*     */     {
/* 100 */       this.info = new JASPIAuthenticationInfo(this.authName);
/*     */     }
/*     */ 
/* 103 */     this.info.add(this.moduleEntries);
/* 104 */     return this.info;
/*     */   }
/*     */ 
/*     */   public Class getTargetClass()
/*     */   {
/* 109 */     return BaseAuthenticationInfo.class;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.login.AuthenticationInfoContainer
 * JD-Core Version:    0.6.0
 */